/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.WeightedRandomLoot;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class LootSettings {
    private Map<Loot, IWeighted<ItemStack>> loot = new HashMap<Loot, IWeighted<ItemStack>>();

    public LootSettings(int level) {
        for (Loot type : Loot.values()) {
            this.loot.put(type, Loot.getProvider(type, level));
        }
    }

    public LootSettings(LootSettings toCopy) {
        this.loot.putAll(toCopy.loot);
    }

    public LootSettings(LootSettings base, LootSettings override) {
        if (base != null) {
            this.loot.putAll(base.loot);
        }
        if (override != null) {
            this.loot.putAll(override.loot);
        }
    }

    public LootSettings(JsonObject data) {
        for (Loot type : Loot.values()) {
            if (!data.has(type.toString())) continue;
            JsonElement providerData = data.get(type.toString());
            if (providerData.isJsonObject()) {
                try {
                    this.loot.put(type, new WeightedRandomLoot(providerData.getAsJsonObject(), 0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!providerData.isJsonArray()) continue;
            WeightedRandomizer<ItemStack> items = new WeightedRandomizer<ItemStack>(0);
            JsonArray lootList = providerData.getAsJsonArray();
            for (JsonElement e : lootList) {
                items.add(this.parseProvider(e.getAsJsonObject()));
            }
            this.loot.put(type, items);
        }
    }

    private IWeighted<ItemStack> parseProvider(JsonObject data) {
        int weight = data.has("weight") ? data.get("weight").getAsInt() : 1;
        JsonElement loot = data.get("data");
        if (loot.isJsonObject()) {
            try {
                return new WeightedRandomLoot(loot.getAsJsonObject(), weight);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        JsonArray lootList = loot.getAsJsonArray();
        WeightedRandomizer<ItemStack> items = new WeightedRandomizer<ItemStack>(weight);
        for (JsonElement e : lootList) {
            items.add(this.parseProvider(e.getAsJsonObject()));
        }
        return items;
    }

    public ItemStack get(Loot type, Random rand) {
        IWeighted<ItemStack> provider = this.loot.get((Object)type);
        return provider.get(rand);
    }

    public IWeighted<ItemStack> get(Loot type) {
        return this.loot.get((Object)type);
    }

    public void set(Loot type, IWeighted<ItemStack> provider) {
        this.loot.put(type, provider);
    }
}

