/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.betterdisplays.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.torgy.torgo.init.TorgoBlocks;

public class TileEntityDisplayCase
extends TileEntity {
    private ItemStack stack;
    private int rotationX = 0;
    private int rotationY = 0;
    private int rotationZ = 0;
    private IBlockState mainBlock = Blocks.field_150344_f.func_176223_P();
    private IBlockState glassBlock = TorgoBlocks.GLOWSTONE_GLASS.func_176223_P();
    private IBlockState carpetBlock;

    public TileEntityDisplayCase() {
        this.stack = ItemStack.field_190927_a;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setXRotation(int rotation) {
        this.rotationX = rotation % 8;
    }

    public void setYRotation(int rotation) {
        this.rotationY = rotation % 8;
    }

    public void setZRotation(int rotation) {
        this.rotationZ = rotation % 8;
    }

    public int getXRotation() {
        return this.rotationX;
    }

    public int getYRotation() {
        return this.rotationY;
    }

    public int getZRotation() {
        return this.rotationZ;
    }

    public void incrementXRotation() {
        this.setXRotation(this.getXRotation() + 1);
    }

    public void incrementYRotation() {
        this.setYRotation(this.getYRotation() + 1);
    }

    public void incrementZRotation() {
        this.setZRotation(this.getZRotation() + 1);
    }

    public void setMainBlock(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        this.mainBlock = block.func_176203_a(itemStack.func_77960_j());
        this.field_145850_b.func_175722_b(this.field_174879_c, this.field_145854_h, true);
        this.func_70296_d();
    }

    public void setGlassBlock(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        this.glassBlock = block.func_176203_a(itemStack.func_77960_j());
        this.field_145850_b.func_175722_b(this.field_174879_c, this.field_145854_h, true);
        this.func_70296_d();
    }

    public void setCarpetBlock(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        this.carpetBlock = block.func_176203_a(itemStack.func_77960_j());
        this.field_145850_b.func_175722_b(this.field_174879_c, this.field_145854_h, true);
        this.func_70296_d();
    }

    public IBlockState getMainBlock() {
        return this.mainBlock;
    }

    public IBlockState getGlassBlock() {
        return this.glassBlock;
    }

    public IBlockState getCarpetBlock() {
        return this.carpetBlock;
    }

    public void rotateItem(EnumFacing side) {
        switch (side) {
            case EAST: 
            case WEST: {
                this.incrementZRotation();
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.incrementXRotation();
                break;
            }
            case UP: 
            case DOWN: {
                this.incrementYRotation();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound itemTag = new NBTTagCompound();
        this.stack.func_77955_b(itemTag);
        nbt.func_74782_a("item", (NBTBase)itemTag);
        nbt.func_74768_a("rotationX", this.rotationX);
        nbt.func_74768_a("rotationY", this.rotationY);
        nbt.func_74768_a("rotationZ", this.rotationZ);
        if (this.mainBlock != null) {
            nbt.func_74778_a("main_block", this.mainBlock.func_177230_c().getRegistryName().toString());
            nbt.func_74768_a("main_block_meta", this.mainBlock.func_177230_c().func_176201_c(this.mainBlock));
        }
        if (this.glassBlock != null) {
            nbt.func_74778_a("glass_block", this.glassBlock.func_177230_c().getRegistryName().toString());
            nbt.func_74768_a("glass_block_meta", this.glassBlock.func_177230_c().func_176201_c(this.glassBlock));
        }
        if (this.carpetBlock != null) {
            nbt.func_74778_a("carpet_block", this.carpetBlock.func_177230_c().getRegistryName().toString());
            nbt.func_74768_a("carpet_block_meta", this.carpetBlock.func_177230_c().func_176201_c(this.carpetBlock));
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        String carpet_block;
        String glass_block;
        super.func_145839_a(nbt);
        NBTTagCompound itemTag = nbt.func_74775_l("item");
        this.rotationX = nbt.func_74762_e("rotationX");
        this.rotationY = nbt.func_74762_e("rotationY");
        this.rotationZ = nbt.func_74762_e("rotationZ");
        this.stack = new ItemStack(itemTag);
        String main_block = nbt.func_74779_i("main_block");
        if (!main_block.isEmpty()) {
            this.mainBlock = Block.func_149684_b((String)main_block).func_176203_a(nbt.func_74762_e("main_block_meta"));
        }
        if (!(glass_block = nbt.func_74779_i("glass_block")).isEmpty()) {
            this.glassBlock = Block.func_149684_b((String)glass_block).func_176203_a(nbt.func_74762_e("glass_block_meta"));
        }
        if (!(carpet_block = nbt.func_74779_i("carpet_block")).isEmpty()) {
            this.carpetBlock = Block.func_149684_b((String)carpet_block).func_176203_a(nbt.func_74762_e("carpet_block_meta"));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

