/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.api.util.DimensionalCoord;
import appeng.services.compass.CompassReader;
import appeng.services.compass.ICompassCallback;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class CompassService {
    private static final int CHUNK_SIZE = 16;
    private final Map<World, CompassReader> worldSet = new HashMap<World, CompassReader>(10);
    private final ExecutorService executor;
    private final File worldCompassFolder;
    private int jobSize;

    public CompassService(@Nonnull File worldCompassFolder, @Nonnull ThreadFactory factory) {
        Preconditions.checkNotNull((Object)worldCompassFolder);
        this.worldCompassFolder = worldCompassFolder;
        this.executor = Executors.newSingleThreadExecutor(factory);
        this.jobSize = 0;
    }

    public Future<?> getCompassDirection(DimensionalCoord coord, int maxRange, ICompassCallback cc) {
        ++this.jobSize;
        return this.executor.submit(new CMDirectionRequest(coord, maxRange, cc));
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload event) {
        if (Platform.isServer() && this.worldSet.containsKey(event.getWorld())) {
            CompassReader compassReader = this.worldSet.remove(event.getWorld());
            compassReader.close();
        }
    }

    private int jobSize() {
        return this.jobSize;
    }

    private void cleanUp() {
        for (CompassReader cr : this.worldSet.values()) {
            cr.close();
        }
    }

    public void updateArea(World w, int chunkX, int chunkZ) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        this.updateArea(w, x, 16, z);
        this.updateArea(w, x, 48, z);
        this.updateArea(w, x, 80, z);
        this.updateArea(w, x, 112, z);
        this.updateArea(w, x, 144, z);
        this.updateArea(w, x, 176, z);
        this.updateArea(w, x, 208, z);
        this.updateArea(w, x, 240, z);
    }

    public Future<?> updateArea(World w, int x, int y, int z) {
        ++this.jobSize;
        int cx = x >> 4;
        int cdy = y >> 5;
        int cz = z >> 4;
        int low_y = cdy << 5;
        int hi_y = low_y + 32;
        Chunk c = w.func_72964_e(cx, cz);
        IBlockState maybeBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("aether_legacy:locked_dungeon_block"))).func_176203_a(5);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = low_y; k < hi_y; ++k) {
                    Block blk = c.func_186032_a(i, k, j).func_177230_c();
                    if (blk != maybeBlock) continue;
                    return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, true));
                }
            }
        }
        return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, false));
    }

    public void kill() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(6L, TimeUnit.MINUTES);
            this.jobSize = 0;
            for (CompassReader cr : this.worldSet.values()) {
                cr.close();
            }
            this.worldSet.clear();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private CompassReader getReader(World w) {
        CompassReader cr = this.worldSet.get(w);
        if (cr == null) {
            cr = new CompassReader(w.field_73011_w.getDimension(), this.worldCompassFolder);
            this.worldSet.put(w, cr);
        }
        return cr;
    }

    private int dist(int ax, int az, int bx, int bz) {
        int up = (bz - az) * 16;
        int side = (bx - ax) * 16;
        return up * up + side * side;
    }

    private double rad(int ax, int az, int bx, int bz) {
        int up = bz - az;
        int side = bx - ax;
        return Math.atan2(-up, side) - 1.5707963267948966;
    }

    private class CMDirectionRequest
    implements Runnable {
        public final int maxRange;
        public final DimensionalCoord coord;
        public final ICompassCallback callback;

        public CMDirectionRequest(DimensionalCoord coord, int getMaxRange, ICompassCallback cc) {
            this.coord = coord;
            this.maxRange = getMaxRange;
            this.callback = cc;
        }

        @Override
        public void run() {
            CompassService.this.jobSize--;
            int cx = this.coord.x >> 4;
            int cz = this.coord.z >> 4;
            CompassReader cr = CompassService.this.getReader(this.coord.getWorld());
            if (cr.hasBeacon(cx, cz)) {
                this.callback.calculatedDirection(true, true, -999.0, 0.0);
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            for (int offset = 1; offset < this.maxRange; ++offset) {
                int closeness;
                int minX = cx - offset;
                int minZ = cz - offset;
                int maxX = cx + offset;
                int maxZ = cz + offset;
                int closest = Integer.MAX_VALUE;
                int chosen_x = cx;
                int chosen_z = cz;
                for (int z = minZ; z <= maxZ; ++z) {
                    if (cr.hasBeacon(minX, z) && (closeness = CompassService.this.dist(cx, cz, minX, z)) < closest) {
                        closest = closeness;
                        chosen_x = minX;
                        chosen_z = z;
                    }
                    if (!cr.hasBeacon(maxX, z) || (closeness = CompassService.this.dist(cx, cz, maxX, z)) >= closest) continue;
                    closest = closeness;
                    chosen_x = maxX;
                    chosen_z = z;
                }
                for (int x = minX + 1; x < maxX; ++x) {
                    if (cr.hasBeacon(x, minZ) && (closeness = CompassService.this.dist(cx, cz, x, minZ)) < closest) {
                        closest = closeness;
                        chosen_x = x;
                        chosen_z = minZ;
                    }
                    if (!cr.hasBeacon(x, maxZ) || (closeness = CompassService.this.dist(cx, cz, x, maxZ)) >= closest) continue;
                    closest = closeness;
                    chosen_x = x;
                    chosen_z = maxZ;
                }
                if (closest >= Integer.MAX_VALUE) continue;
                this.callback.calculatedDirection(true, false, CompassService.this.rad(cx, cz, chosen_x, chosen_z), CompassService.this.dist(cx, cz, chosen_x, chosen_z));
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            this.callback.calculatedDirection(false, true, -999.0, 999.0);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }

    private class CMUpdatePost
    implements Runnable {
        public final World world;
        public final int chunkX;
        public final int chunkZ;
        public final int doubleChunkY;
        public final boolean value;

        public CMUpdatePost(World w, int cx, int cz, int dcy, boolean val) {
            this.world = w;
            this.chunkX = cx;
            this.doubleChunkY = dcy;
            this.chunkZ = cz;
            this.value = val;
        }

        @Override
        public void run() {
            CompassService.this.jobSize--;
            CompassReader cr = CompassService.this.getReader(this.world);
            cr.setHasBeacon(this.chunkX, this.chunkZ, this.doubleChunkY, this.value);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }
}

