/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.AEColor;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.client.render.model.ColorApplicatorModel;
import appeng.items.tools.powered.ToolColorApplicator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolColorApplicatorRendering
extends ItemRenderingCustomizer {
    private static final ModelResourceLocation MODEL_COLORED = new ModelResourceLocation(new ResourceLocation("appliedenergistics2", "builtin/color_applicator_colored"), "inventory");
    private static final ModelResourceLocation MODEL_UNCOLORED = new ModelResourceLocation(new ResourceLocation("appliedenergistics2", "color_applicator_uncolored"), "inventory");

    @Override
    @SideOnly(value=Side.CLIENT)
    public void customize(IItemRendering rendering) {
        rendering.builtInModel("models/item/builtin/color_applicator_colored", new ColorApplicatorModel());
        rendering.variants(new ResourceLocation[]{MODEL_COLORED, MODEL_UNCOLORED});
        rendering.color(this::getColor);
        rendering.meshDefinition(this::getMesh);
    }

    private ModelResourceLocation getMesh(ItemStack itemStack) {
        AEColor col = ((ToolColorApplicator)itemStack.func_77973_b()).getActiveColor(itemStack);
        return col != null ? MODEL_COLORED : MODEL_UNCOLORED;
    }

    private int getColor(ItemStack itemStack, int idx) {
        if (idx == 0) {
            return -1;
        }
        AEColor col = ((ToolColorApplicator)itemStack.func_77973_b()).getActiveColor(itemStack);
        if (col == null) {
            return -1;
        }
        switch (idx) {
            case 1: {
                return col.blackVariant;
            }
            case 2: {
                return col.mediumVariant;
            }
            case 3: {
                return col.whiteVariant;
            }
        }
        return -1;
    }
}

