/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.networking.energy.IAEPowerStorage;
import appeng.integration.modules.waila.BaseWailaDataProvider;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class PowerStorageWailaDataProvider
extends BaseWailaDataProvider {
    private static final String ID_CURRENT_POWER = "currentPower";
    private final Object2LongMap<TileEntity> cache = new Object2LongOpenHashMap();

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IAEPowerStorage storage;
        double maxPower;
        ((ITaggedList)currentToolTip).removeEntries((Object)"RFEnergyStorage");
        TileEntity te = accessor.getTileEntity();
        if (te instanceof IAEPowerStorage && (maxPower = (storage = (IAEPowerStorage)te).getAEMaxPower()) > 0.0) {
            NBTTagCompound tag = accessor.getNBTData();
            long l = this.getInternalCurrentPower(tag, te);
        }
        return currentToolTip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        IAEPowerStorage storage;
        if (te instanceof IAEPowerStorage && (storage = (IAEPowerStorage)te).getAEMaxPower() > 0.0) {
            long internalCurrentPower = (long)(100.0 * storage.getAECurrentPower());
            tag.func_74772_a(ID_CURRENT_POWER, internalCurrentPower);
        }
        return tag;
    }

    private long getInternalCurrentPower(NBTTagCompound tag, TileEntity te) {
        long internalCurrentPower;
        if (tag.func_74764_b(ID_CURRENT_POWER)) {
            internalCurrentPower = tag.func_74763_f(ID_CURRENT_POWER);
            this.cache.put((Object)te, internalCurrentPower);
        } else {
            internalCurrentPower = this.cache.containsKey((Object)te) ? (Long)this.cache.get((Object)te) : -1L;
        }
        return internalCurrentPower;
    }
}

