/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.items;

import appeng.api.AEApi;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.fluids.helper.FluidCellConfig;
import appeng.items.materials.MaterialType;
import appeng.items.storage.AbstractStorageCell;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class BasicFluidStorageCell
extends AbstractStorageCell<IAEFluidStack> {
    private final int perType;
    private final double idleDrain;

    public BasicFluidStorageCell(MaterialType whichCell, int kilobytes) {
        super(whichCell, kilobytes);
        switch (whichCell) {
            case FLUID_CELL1K_PART: {
                this.idleDrain = 0.5;
                this.perType = 8;
                break;
            }
            case FLUID_CELL4K_PART: {
                this.idleDrain = 1.0;
                this.perType = 32;
                break;
            }
            case FLUID_CELL16K_PART: {
                this.idleDrain = 1.5;
                this.perType = 128;
                break;
            }
            case FLUID_CELL64K_PART: {
                this.idleDrain = 2.0;
                this.perType = 512;
                break;
            }
            default: {
                this.idleDrain = 0.0;
                this.perType = 8;
            }
        }
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    @Override
    public IStorageChannel<IAEFluidStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 5;
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new FluidCellConfig(is);
    }
}

