/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class HUDHandlerBlocks
implements IWailaDataProvider {
    static final IWailaDataProvider INSTANCE = new HUDHandlerBlocks();

    @Override
    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlockState().func_185904_a().func_76224_d()) {
            return currenttip;
        }
        String name = null;
        String displayName = DisplayUtil.itemDisplayNameShort(itemStack);
        if (displayName != null && !displayName.endsWith("Unnamed")) {
            name = displayName;
        }
        if (name != null) {
            currenttip.add(name);
        }
        if (itemStack.func_77973_b() == Items.field_151137_ax) {
            int md = accessor.getMetadata();
            String redstoneMeta = "" + md;
            if (redstoneMeta.length() < 2) {
                redstoneMeta = " " + redstoneMeta;
            }
            currenttip.set(currenttip.size() - 1, name + " " + redstoneMeta);
        }
        if (currenttip.size() == 0) {
            currenttip.add("\u00a7r" + String.format(FormattingConfig.blockFormat, "< Unnamed >"));
        } else if (ConfigHandler.instance().getConfig("general", "waila.cfg.metadata", true) && !Strings.isNullOrEmpty((String)FormattingConfig.metaFormat)) {
            currenttip.add("\u00a7r" + String.format(FormattingConfig.blockFormat, accessor.getBlock().getRegistryName().toString(), accessor.getMetadata()));
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (config.getConfig("general.showstates")) {
            IBlockState actualState = accessor.getBlockState().func_177230_c().func_176221_a(accessor.getBlockState(), (IBlockAccess)accessor.getWorld(), accessor.getPosition());
            BlockStateContainer container = accessor.getBlock().func_176194_O();
            for (IProperty property : container.func_177623_d()) {
                Comparable comparable = actualState.func_177229_b(property);
            }
        }
        return tooltip;
    }

    @Override
    @Nonnull
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlockState().func_185904_a().func_76224_d()) {
            return currenttip;
        }
        return currenttip;
    }
}

