/*
 * Decompiled with CFR 0.152.
 */
package quaternary.simpletrophies.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.simpletrophies.common.etc.EnumTrophyVariant;
import quaternary.simpletrophies.common.etc.TrophyHelpers;
import quaternary.simpletrophies.common.tile.TileSimpleTrophy;

public class BlockSimpleTrophy
extends Block {
    public static final String KEY_NAME = "TrophyName";
    public static final String KEY_ITEM = "TrophyItem";
    public static final String KEY_COLOR_RED = "TrophyColorRed";
    public static final String KEY_COLOR_GREEN = "TrophyColorGreen";
    public static final String KEY_COLOR_BLUE = "TrophyColorBlue";
    public static final String KEY_VARIANT = "TrophyVariant";
    public static final String KEY_EARNED_AT = "TrophyEarnedAt";
    public static final String KEY_SHOWS_TOOLTIP = "TrophyShowsTooltip";
    public static final PropertyEnum<EnumTrophyVariant> PROP_VARIANT = PropertyEnum.func_177709_a((String)"trophy_variant", EnumTrophyVariant.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockSimpleTrophy() {
        super(Material.field_151576_e, MapColor.field_151647_F);
        this.func_149711_c(50.0f);
        this.func_149752_b(6000.0f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(PROP_VARIANT, (Comparable)((Object)EnumTrophyVariant.CLASSIC)));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSimpleTrophy();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_184812_l_()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSimpleTrophy) {
            TileSimpleTrophy trophy = (TileSimpleTrophy)tile;
            int averageColor = BlockSimpleTrophy.getAverageDyeColorHeldByPlayer(player);
            if (averageColor == -1) {
                trophy.displayedStack = player.func_184586_b(hand).func_77946_l();
            } else {
                trophy.displayedColorRed = (averageColor & 0xFF0000) >> 16;
                trophy.displayedColorGreen = (averageColor & 0xFF00) >> 8;
                trophy.displayedColorBlue = averageColor & 0xFF;
            }
            IBlockState hahaYes = world.func_180495_p(pos);
            world.func_184138_a(pos, hahaYes, hahaYes, 2);
            trophy.func_70296_d();
            return true;
        }
        return false;
    }

    private static int getAverageDyeColorHeldByPlayer(EntityPlayer player) {
        ItemStack off;
        int color = -1;
        ItemStack main = player.func_184586_b(EnumHand.MAIN_HAND);
        if (main.func_77973_b() instanceof ItemDye && MathHelper.func_76125_a((int)main.func_77960_j(), (int)0, (int)15) == main.func_77960_j()) {
            color = ItemDye.field_150922_c[main.func_77960_j()];
        }
        if ((off = player.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() instanceof ItemDye && MathHelper.func_76125_a((int)off.func_77960_j(), (int)0, (int)15) == off.func_77960_j()) {
            int color2 = ItemDye.field_150922_c[off.func_77960_j()];
            int red = (((color & 0xFF0000) >> 16) + ((color2 & 0xFF0000) >> 16)) / 2;
            int green = (((color & 0xFF00) >> 8) + ((color2 & 0xFF00) >> 8)) / 2;
            int blue = ((color & 0xFF) + (color2 & 0xFF)) / 2;
            color = red << 16 | green << 8 | blue;
        }
        return color;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSimpleTrophy) {
            BlockSimpleTrophy.func_180635_a((World)world, (BlockPos)pos, (ItemStack)TrophyHelpers.createItemStackFromTile((TileSimpleTrophy)tile));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROP_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSimpleTrophy) {
            return state.func_177226_a(PROP_VARIANT, (Comparable)((Object)((TileSimpleTrophy)tile).displayedVariant));
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        return TrophyHelpers.createItemStackFromTile(tile instanceof TileSimpleTrophy ? (TileSimpleTrophy)tile : null);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }
}

