/*
 * Decompiled with CFR 0.152.
 */
package quaternary.simpletrophies.client.tesr;

import java.util.EnumMap;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import quaternary.simpletrophies.SimpleTrophies;
import quaternary.simpletrophies.client.ClientGameEvents;
import quaternary.simpletrophies.common.block.BlockSimpleTrophy;
import quaternary.simpletrophies.common.config.SimpleTrophiesConfig;
import quaternary.simpletrophies.common.etc.EnumTrophyVariant;
import quaternary.simpletrophies.common.etc.TrophyHelpers;
import quaternary.simpletrophies.common.item.ItemSimpleTrophy;

public class RenderItemStackSimpleTrophy
extends TileEntityItemStackRenderer {
    public static final EnumMap<EnumTrophyVariant, ModelResourceLocation> baseLocations = new EnumMap(EnumTrophyVariant.class);
    static final EnumMap<EnumTrophyVariant, IBakedModel> baseModels;
    int recursionDepth = 0;

    public static void dumpCache() {
        baseModels.clear();
    }

    public void func_179022_a(ItemStack stack) {
        ItemStack displayedStack;
        if (SimpleTrophiesConfig.NO_TEISR || !(stack.func_77973_b() instanceof ItemSimpleTrophy)) {
            return;
        }
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        if (!SimpleTrophiesConfig.SKIP_ITEM_BASES) {
            EnumTrophyVariant baseVariant = TrophyHelpers.getDisplayedVariant(stack);
            IBakedModel baseModel = baseModels.computeIfAbsent(baseVariant, var -> brd.func_175023_a().func_178126_b().func_174953_a(baseLocations.get(var)));
            int color = TrophyHelpers.getCombinedColor(stack);
            float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float green = (float)((color & 0xFF00) >> 8) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            brd.func_175019_b().func_178262_a(baseModel, 1.0f, red, green, blue);
        }
        if (!SimpleTrophiesConfig.SKIP_ITEM_ITEMS && !(displayedStack = TrophyHelpers.getDisplayedStack(stack)).func_190926_b()) {
            float ticks = ClientGameEvents.getPauseAdjustedTicksAndPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)0.55, (double)0.5);
            if (!Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(displayedStack).func_177556_c()) {
                GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            }
            GlStateManager.func_179114_b((float)(ticks * 2.5f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            ++this.recursionDepth;
            if (this.recursionDepth < 5) {
                try {
                    Minecraft.func_71410_x().func_175599_af().func_181564_a(displayedStack, ItemCameraTransforms.TransformType.GROUND);
                }
                catch (Exception oof) {
                    SimpleTrophies.LOG.error("Problem rendering item on a trophy TEISR", (Throwable)oof);
                }
            }
            --this.recursionDepth;
            GlStateManager.func_179147_l();
            GlStateManager.func_179121_F();
        }
    }

    static {
        PropertyEnum<EnumTrophyVariant> propVariant = BlockSimpleTrophy.PROP_VARIANT;
        String variantName = propVariant.func_177701_a();
        for (EnumTrophyVariant var : EnumTrophyVariant.VALUES) {
            baseLocations.put(var, new ModelResourceLocation(new ResourceLocation("simple_trophies", "trophy"), variantName + '=' + propVariant.func_177702_a((Enum)var)));
        }
        baseModels = new EnumMap(EnumTrophyVariant.class);
    }
}

