/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class GeneratorSplotches
extends GeneratorReplacing {
    protected int splotchSize;

    public GeneratorSplotches(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int splotchSize) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.splotchSize = splotchSize;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (!this.placeOn.matches(world, pos.func_177977_b())) {
            return false;
        }
        float a = random.nextFloat() * (float)Math.PI;
        double x0 = (float)pos.func_177958_n() + MathHelper.func_76126_a((float)a) * (float)this.splotchSize / 8.0f;
        double y0 = pos.func_177956_o() + random.nextInt(3) - 1;
        double z0 = (float)pos.func_177952_p() + MathHelper.func_76134_b((float)a) * (float)this.splotchSize / 8.0f;
        double x1 = (float)pos.func_177958_n() - MathHelper.func_76126_a((float)a) * (float)this.splotchSize / 8.0f;
        double y1 = pos.func_177956_o() + random.nextInt(3) - 1;
        double z1 = (float)pos.func_177952_p() - MathHelper.func_76134_b((float)a) * (float)this.splotchSize / 8.0f;
        for (int i = 0; i <= this.splotchSize; ++i) {
            double x = x0 + (x1 - x0) * (double)i / (double)this.splotchSize;
            double y = y0 + (y1 - y0) * (double)i / (double)this.splotchSize;
            double z = z0 + (z1 - z0) * (double)i / (double)this.splotchSize;
            double b = random.nextDouble() * (double)this.splotchSize / 16.0;
            double diameterXZ = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.splotchSize)) + 1.0f) * b + 1.0;
            double diameterY = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.splotchSize)) + 1.0f) * b + 1.0;
            this.replaceInEllipsoid(world, x, y, z, diameterXZ / 2.0, diameterY / 2.0, diameterXZ / 2.0);
        }
        return true;
    }

    public void replaceInEllipsoid(World world, double centerX, double centerY, double centerZ, double radiusX, double radiusY, double radiusZ) {
        int x0 = MathHelper.func_76128_c((double)(centerX - radiusX + 0.5));
        int y0 = MathHelper.func_76128_c((double)(centerY - radiusY + 0.5));
        int z0 = MathHelper.func_76128_c((double)(centerZ - radiusZ + 0.5));
        int x1 = MathHelper.func_76128_c((double)(centerX + radiusX + 0.5));
        int y1 = MathHelper.func_76128_c((double)(centerY + radiusY + 0.5));
        int z1 = MathHelper.func_76128_c((double)(centerZ + radiusZ + 0.5));
        for (int x = x0; x <= x1; ++x) {
            double px = ((double)x + 0.5 - centerX) / radiusX;
            if (!(px * px < 1.0)) continue;
            for (int y = y0; y <= y1; ++y) {
                double py = ((double)y + 0.5 - centerY) / radiusY;
                if (!(px * px + py * py < 1.0)) continue;
                for (int z = z0; z <= z1; ++z) {
                    double pz = ((double)z + 0.5 - centerZ) / radiusZ;
                    if (!(px * px + py * py + pz * pz < 1.0)) continue;
                    this.replaceAt(world, new BlockPos(x, y, z));
                }
            }
        }
    }

    public void replaceAt(World world, BlockPos pos) {
        if (this.replace.matches(world, pos)) {
            world.func_180501_a(pos, this.with, 2);
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.with = conf.getBlockState("with", this.with);
        this.splotchSize = conf.getInt("splotchSize", this.splotchSize);
        this.scatterYMethod = conf.getEnum("scatterYMethod", this.scatterYMethod, GeneratorUtils.ScatterYMethod.class);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorSplotches>
    implements IGenerator.IGeneratorBuilder<GeneratorSplotches> {
        protected int splotchSize;

        public Builder splotchSize(int a) {
            this.splotchSize = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = new BlockQuery.BlockQueryMaterial(Material.field_151577_b, Material.field_151578_c);
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151577_b, Material.field_151578_c);
            this.with = Blocks.field_150347_e.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.BELOW_SURFACE;
            this.splotchSize = 8;
        }

        @Override
        public GeneratorSplotches create() {
            return new GeneratorSplotches(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.splotchSize);
        }
    }
}

