/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.block;

import biomesoplenty.api.enums.IPagedVariants;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class VariantPagingHelper<B extends Block, V extends Enum<V> & IPagedVariants> {
    protected int variantsPerPage;
    protected Class<V> variantsEnumClass;
    protected Map<Integer, PropertyEnum> pageNumToProperty = new HashMap<Integer, PropertyEnum>();
    protected Map<V, PageIndex> variantToPageIndex = new HashMap<V, PageIndex>();
    protected Map<Integer, V> masterIndexToVariant = new HashMap<Integer, V>();
    protected Map<Integer, B> pageNumToBlock = new HashMap<Integer, B>();
    protected Map<B, Integer> blockToPageNum = new HashMap<B, Integer>();

    public VariantPagingHelper(int variantsPerPage, Class<V> variantsEnumClass) {
        this(variantsPerPage, variantsEnumClass, Predicates.alwaysTrue());
    }

    public VariantPagingHelper(int variantsPerPage, Class<V> variantsEnumClass, Predicate<V> filter) {
        this.variantsPerPage = variantsPerPage;
        this.variantsEnumClass = variantsEnumClass;
        V[] variants = variantsEnumClass.getEnumConstants();
        if (variants == null) {
            throw new IllegalArgumentException("Failed creating PagedBlock - variantsEnumClass has no enum constants - is it an enum class?");
        }
        ArrayList<Enum> currentPage = new ArrayList<Enum>();
        int currentPageNum = 0;
        boolean index = false;
        for (V obj : variants) {
            Enum variant = (Enum)obj;
            if (!filter.apply((Object)variant)) continue;
            currentPage.add(variant);
            if (currentPage.size() != variantsPerPage) continue;
            this.addVariantPage(currentPageNum, currentPage);
            currentPage = new ArrayList();
            ++currentPageNum;
        }
        if (!currentPage.isEmpty()) {
            this.addVariantPage(currentPageNum, currentPage);
        }
    }

    protected void addVariantPage(int pageNum, ArrayList<V> variants) {
        for (int index = 0; index < variants.size(); ++index) {
            Enum variant = (Enum)variants.get(index);
            this.variantToPageIndex.put((PageIndex)((Object)variant), new PageIndex(pageNum, index));
            this.masterIndexToVariant.put(pageNum * this.variantsPerPage + index, variant);
        }
        this.pageNumToProperty.put(pageNum, PropertyEnum.func_177707_a((String)"variant", this.variantsEnumClass, variants));
    }

    public void addBlock(int pageNum, B block) {
        this.pageNumToBlock.put(pageNum, block);
        this.blockToPageNum.put(block, pageNum);
    }

    public int getVariantsPerPage() {
        return this.variantsPerPage;
    }

    public int getNumPages() {
        return this.pageNumToProperty.size();
    }

    public PropertyEnum getVariantProperty(int pageNum) {
        return this.pageNumToProperty.get(pageNum);
    }

    public int getIndex(V variant) {
        return this.variantToPageIndex.get(variant).getIndex();
    }

    public int getPageNum(V variant) {
        return this.variantToPageIndex.get(variant).getPageNum();
    }

    public int getPageNum(B block) {
        return this.blockToPageNum.get(block);
    }

    public V getVariant(int pageNum, int index) {
        Enum value = (Enum)this.masterIndexToVariant.get(pageNum * this.variantsPerPage + index);
        if (value == null) {
            value = (Enum)((Object)this.getBlock((V)pageNum).func_176223_P().func_177229_b((IProperty)this.getVariantProperty(pageNum)));
        }
        return (V)value;
    }

    public V getVariant(B block, int index) {
        return this.getVariant((B)this.getPageNum(block), index);
    }

    public B getBlock(int pageNum) {
        return (B)((Block)this.pageNumToBlock.get(pageNum));
    }

    public B getBlock(V variant) {
        return (B)((Block)this.pageNumToBlock.get(this.getPageNum((B)variant)));
    }

    public IBlockState getVariantState(V variant) {
        return this.getBlock(variant).func_176223_P().func_177226_a((IProperty)this.getVariantProperty(this.getPageNum((B)variant)), variant);
    }

    public ItemStack getVariantItem(V variant) {
        return this.getVariantItem(variant, 1);
    }

    public ItemStack getVariantItem(V variant, int howMany) {
        return new ItemStack(this.getBlock(variant), howMany, this.getBlock(variant).func_176201_c(this.getVariantState(variant)));
    }

    public class PageIndex {
        private int pageNum;
        private int index;

        public PageIndex(int pageNum, int index) {
            this.pageNum = pageNum;
            this.index = index;
        }

        public int getPageNum() {
            return this.pageNum;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "page:" + this.pageNum + " index:" + this.index;
        }
    }
}

