/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPCoral;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLilypad;
import biomesoplenty.common.block.BlockBOPMushroom;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.GeneratorBigMushroom;
import biomesoplenty.common.world.generator.GeneratorBramble;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class BiomeGenMysticGrove
extends BOPOverworldBiome {
    public BiomeGenMysticGrove() {
        super("mystic_grove", new BOPBiome.PropsBuilder("Mystic Grove").withGuiColour(6934491).withTemperature(Float.valueOf(0.7f)).withRainfall(Float.valueOf(0.8f)).withWaterColor(16715898));
        this.terrainSettings.avgHeight(63.0).heightVariation(5.0, 20.0);
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SILTY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SILTY));
        this.skyColor = 0x380000;
        this.fogColor = 0xBF0000;
        this.fogDensity = 0.9f;
        this.canGenerateRivers = true;
        this.canGenerateVillages = false;
        this.canSpawnInBiome = false;
        this.beachBiomeLocation = null;
        this.addWeight(BOPClimates.WET_TEMPERATE, 1);
        this.field_76762_K.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWitch.class, 10, 4, 4));
        GeneratorWeighted treeGenerator = new GeneratorWeighted(10.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("ivy_tree", 7, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(8)).maxHeight(11)).leaves(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false)))).vine(BOPBlocks.ivy.func_176223_P())).create());
        treeGenerator.add("magic", 17, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(5)).maxHeight(13)).log(BOPWoods.MAGIC)).leaves(BOPTrees.MAGIC)).create());
        treeGenerator.add("jacaranda", 9, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(8)).maxHeight(11)).log(BOPWoods.JACARANDA)).leaves(BOPTrees.JACARANDA)).create());
        treeGenerator.add("oak_large", 8, ((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().altLeaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.FLOWERING).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false)))).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(1.5f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(1.5f);
        this.addGenerator("bramble", GeneratorStage.FLOWERS, ((GeneratorBramble.Builder)new GeneratorBramble.Builder().maxHeight(4).minLength(5).maxLength(15).amountPerChunk(0.75f)).create());
        this.addGenerator("poison_ivy", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).generationAttempts(16)).with(BOPPlants.POISONIVY)).create());
        this.addGenerator("thorns", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).with(BOPPlants.THORN)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.3f)).placeOn(BlockQueries.fertile)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(Blocks.field_150392_bi.func_176223_P())).create());
        this.addGenerator("medium_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPLilypad.LilypadType.MEDIUM)).create());
        this.addGenerator("small_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPLilypad.LilypadType.SMALL)).create());
        this.addGenerator("tiny_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BlockBOPLilypad.LilypadType.TINY)).create());
        this.addGenerator("algae", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).replace((Block)Blocks.field_150355_j)).with(BOPBlocks.coral.func_176223_P().func_177226_a((IProperty)BlockBOPCoral.VARIANT, (Comparable)((Object)BlockBOPCoral.CoralType.ALGAE)))).scatterYMethod(GeneratorUtils.ScatterYMethod.AT_GROUND)).create());
        this.addGenerator("flower_lily", GeneratorStage.LILYPAD, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BlockBOPLilypad.LilypadType.FLOWER)).create());
        this.addGenerator("blue_milk_caps", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).generationAttempts(16)).with(BlockBOPMushroom.MushroomType.BLUE_MILK_CAP)).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.4f)).generationAttempts(16)).with(Blocks.field_150337_Q.func_176223_P())).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).generationAttempts(16)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("big_red_mushroom", GeneratorStage.BIG_SHROOM, ((GeneratorBigMushroom.Builder)new GeneratorBigMushroom.Builder().amountPerChunk(0.4f)).mushroomType(GeneratorBigMushroom.BigMushroomType.RED).create());
    }

    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(4541700);
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(0x4A3434);
    }
}

