/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.jei.chopping.manual;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.gory_moon.horsepower.jei.HorsePowerPlugin;
import se.gory_moon.horsepower.jei.chopping.manual.ManualChoppingRecipeWrapper;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.util.Localization;
import se.gory_moon.horsepower.util.color.Colors;

public class HPManualChoppingCategory
implements IRecipeCategory<ManualChoppingRecipeWrapper> {
    private static final int inputSlot = 0;
    private static final int outputSlot = 1;
    private static final int axeSlot = 2;
    private final String localizedName;
    protected IDrawable background;

    public HPManualChoppingCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("horsepower", "textures/gui/jei_manual_chopping.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 78, 44);
        this.localizedName = Localization.GUI.CATEGORY_MANUAL_CHOPPING.translate(new Object[0]);
    }

    public String getUid() {
        return "horsepower.manual_chopping";
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Horse Power";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ManualChoppingRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 2) {
                int base = TileEntityManualChopper.getBaseAmount(ingredient, null);
                int chance = TileEntityManualChopper.getChance(ingredient, null);
                tooltip.add((Object)((Object)Colors.LIGHTGRAY) + Localization.GUI.JEI.MANUAL_CHOPPING_DESC_1.translate(Colors.WHITE.toString() + base));
                tooltip.add((Object)((Object)Colors.LIGHTGRAY) + Localization.GUI.JEI.MANUAL_CHOPPING_DESC_2.translate(Colors.WHITE.toString() + chance));
                tooltip.add((Object)((Object)Colors.LIGHTGRAY) + "\n" + Localization.GUI.JEI.MANUAL_CHOPPING_DESC_3.translate(new Object[]{Colors.WHITE, Colors.LIGHTGRAY}));
            }
        });
        guiItemStacks.setOverrideDisplayFocus(null);
        guiItemStacks.init(0, true, 0, 22);
        guiItemStacks.init(1, false, 56, 22);
        guiItemStacks.init(2, true, 26, 0);
        IFocus focus = recipeLayout.getFocus();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        IStackHelper stackHelper = HorsePowerPlugin.jeiHelpers.getStackHelper();
        if (focus != null && focus.getValue() instanceof ItemStack) {
            ItemStack stack = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.INPUT) {
                int index = -1;
                List stacks = (List)inputs.get(1);
                for (int i = 0; i < stacks.size(); ++i) {
                    if (!stackHelper.isEquivalent((ItemStack)stacks.get(i), stack)) continue;
                    index = i;
                    break;
                }
                if (index > -1) {
                    ((List)inputs.get(1)).removeIf(itemStack -> !stackHelper.isEquivalent(stack, itemStack));
                    ItemStack output = (ItemStack)((List)outputs.get(0)).get(index);
                    ((List)outputs.get(0)).removeIf(itemStack -> output != itemStack);
                }
            }
        }
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(2, (List)inputs.get(1));
        guiItemStacks.set(1, (List)outputs.get(0));
    }
}

