/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.blocks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.blocks.BlockChoppingBlock;
import se.gory_moon.horsepower.blocks.BlockFiller;
import se.gory_moon.horsepower.blocks.BlockGrindstone;
import se.gory_moon.horsepower.blocks.BlockHandGrindstone;
import se.gory_moon.horsepower.blocks.BlockPress;
import se.gory_moon.horsepower.items.ItemBlockDouble;
import se.gory_moon.horsepower.tileentity.TileEntityChopper;
import se.gory_moon.horsepower.tileentity.TileEntityFiller;
import se.gory_moon.horsepower.tileentity.TileEntityGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityHandGrindstone;
import se.gory_moon.horsepower.tileentity.TileEntityManualChopper;
import se.gory_moon.horsepower.tileentity.TileEntityPress;

public class ModBlocks {
    public static final BlockHandGrindstone BLOCK_HAND_GRINDSTONE = new BlockHandGrindstone();
    public static final BlockGrindstone BLOCK_GRINDSTONE = new BlockGrindstone();
    public static final BlockChoppingBlock BLOCK_MANUAL_CHOPPER = new BlockChoppingBlock();
    public static final BlockChopper BLOCK_CHOPPER = new BlockChopper();
    public static final BlockFiller BLOCK_CHOPPER_FILLER = (BlockFiller)new BlockFiller(Material.field_151575_d, "chopper_", true).setHarvestLevel1("axe", 0).func_149711_c(5.0f).func_149752_b(5.0f);
    public static final BlockPress BLOCK_PRESS = new BlockPress();
    public static final BlockFiller BLOCK_PRESS_FILLER = (BlockFiller)new BlockFiller(Material.field_151575_d, "press_", true).setHarvestLevel1("axe", 1).func_149711_c(5.0f).func_149752_b(5.0f);

    public static void registerTileEntities() {
        ModBlocks.registerTileEntity(TileEntityHandGrindstone.class);
        ModBlocks.registerTileEntity(TileEntityGrindstone.class);
        ModBlocks.registerTileEntity(TileEntityManualChopper.class);
        ModBlocks.registerTileEntity(TileEntityChopper.class);
        ModBlocks.registerTileEntity(TileEntityFiller.class);
        ModBlocks.registerTileEntity(TileEntityPress.class);
    }

    private static void registerTileEntity(Class<? extends TileEntity> tileEntityClass) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)("horsepower:" + tileEntityClass.getSimpleName().replaceFirst("TileEntity", "")));
    }

    @Mod.EventBusSubscriber(modid="horsepower")
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            BLOCK_PRESS_FILLER.setHarvestLevel("axe", 1);
            Block[] blocks = new Block[]{BLOCK_HAND_GRINDSTONE, BLOCK_GRINDSTONE, BLOCK_MANUAL_CHOPPER, BLOCK_CHOPPER, BLOCK_CHOPPER_FILLER, BLOCK_PRESS, BLOCK_PRESS_FILLER};
            registry.registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)BLOCK_HAND_GRINDSTONE), new ItemBlock((Block)BLOCK_GRINDSTONE), new ItemBlock((Block)BLOCK_MANUAL_CHOPPER), new ItemBlockDouble(BLOCK_CHOPPER, (Block)BLOCK_CHOPPER_FILLER), new ItemBlockDouble(BLOCK_PRESS, (Block)BLOCK_PRESS_FILLER)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : items) {
                registry.register(item.setRegistryName(item.func_179223_d().getRegistryName()));
                ITEM_BLOCKS.add(item);
            }
        }
    }
}

