/*
 * Decompiled with CFR 0.152.
 */
package elec332.huds.util;

import com.google.common.collect.Maps;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IAPIHandler;
import elec332.huds.api.IItemDamageManager;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum ItemDamageHelper implements IItemDamageManager
{
    INSTANCE;

    private final Map<Item, ToIntFunction<ItemStack>> damageGetters = Maps.newIdentityHashMap();
    private final Map<Item, ToIntFunction<ItemStack>> maxDamageGetters = Maps.newIdentityHashMap();
    private final ToIntFunction<ItemStack> defaultDamageGetter = ItemStack::func_77952_i;
    private final ToIntFunction<ItemStack> defaultMaxDamageGetter = ItemStack::func_77958_k;

    @Override
    public void registerDamageGetter(Item item, ToIntFunction<ItemStack> damageGetter) {
        this.damageGetters.put(item, damageGetter);
    }

    @Override
    public void registerMaxDamageGetter(Item item, ToIntFunction<ItemStack> maxDamageGetter) {
        this.maxDamageGetters.put(item, maxDamageGetter);
    }

    public int getDamage(ItemStack stack) {
        return this.damageGetters.getOrDefault(stack.func_77973_b(), this.defaultDamageGetter).applyAsInt(stack);
    }

    public int getMaxItemDamage(ItemStack stack) {
        return this.maxDamageGetters.getOrDefault(stack.func_77973_b(), this.defaultMaxDamageGetter).applyAsInt(stack);
    }

    @APIHandlerInject
    private void injectRenderingRegistry(IAPIHandler apiHandler) {
        apiHandler.inject((Object)INSTANCE, new Class[]{IItemDamageManager.class});
    }
}

