/*
 * Decompiled with CFR 0.152.
 */
package elec332.huds.client.hud.armor;

import elec332.huds.client.hud.armor.IDamageDisplayType;
import elec332.huds.util.ItemDamageHelper;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public enum DamageDisplayType implements IDamageDisplayType
{
    DAMAGE{

        @Override
        public String getDamageForDisplay(@Nonnull ItemStack stack) {
            return DamageDisplayType.EMPTY + ItemDamageHelper.INSTANCE.getDamage(stack);
        }
    }
    ,
    USES_LEFT{

        @Override
        public String getDamageForDisplay(@Nonnull ItemStack stack) {
            return DamageDisplayType.EMPTY + (ItemDamageHelper.INSTANCE.getMaxItemDamage(stack) - ItemDamageHelper.INSTANCE.getDamage(stack));
        }
    }
    ,
    PERCENT{
        private final DecimalFormat format = new DecimalFormat("###.#");

        @Override
        public String getDamageForDisplay(@Nonnull ItemStack stack) {
            int damage = ItemDamageHelper.INSTANCE.getDamage(stack);
            int maxDamage = ItemDamageHelper.INSTANCE.getMaxItemDamage(stack);
            return this.format.format((float)(maxDamage - damage) / (float)maxDamage * 100.0f) + "%";
        }
    }
    ,
    NONE{

        @Override
        public String getDamageForDisplay(@Nonnull ItemStack stack) {
            return null;
        }
    };

    private static final String EMPTY = "";

    private DamageDisplayType() {
    }

    private DamageDisplayType(Object x2) {
        this();
    }
}

