/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidatedNBT;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.init.TFItems;
import cofh.thermalfoundation.item.ItemMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeManager {
    private static Map<ComparableItemStackValidatedNBT, CentrifugeRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static OreValidator oreValidator = new OreValidator();
    public static final int DEFAULT_ENERGY = 10000;

    public static CentrifugeRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidatedNBT query = CentrifugeManager.convertInput(input);
        CentrifugeRecipe recipe = recipeMap.get(query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return CentrifugeManager.getRecipe(input) != null;
    }

    public static CentrifugeRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new CentrifugeRecipe[0]);
    }

    public static void initialize() {
        int energy = 10000;
        CentrifugeManager.addRecipe(energy, new ItemStack(Items.field_151064_bs), Arrays.asList(new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_151065_br)), null);
        CentrifugeManager.addRecipe(energy, new ItemStack(Items.field_151120_aE), Collections.singletonList(new ItemStack(Items.field_151102_aT, 2)), new FluidStack(FluidRegistry.WATER, 250));
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustElectrum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustGold), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), null);
        CentrifugeManager.addRecipe(energy * 3, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustInvar, (int)3), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustIron, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNickel)), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBronze, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustTin)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustConstantan, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNickel)), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSignalum, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), new FluidStack(TFFluids.fluidRedstone, 1000));
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustLumium, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustTin, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), new FluidStack(TFFluids.fluidGlowstone, 1000));
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustEnderium, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustLead, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPlatinum)), new FluidStack(TFFluids.fluidEnder, 1000));
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPyrotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((Item)Items.field_151065_br, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSulfur), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCryotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlizz, (int)2), ItemHelper.cloneStack((Item)Items.field_151126_ay), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustAerotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlitz, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNiter), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPetrotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBasalz, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian), new ItemStack(Items.field_151137_ax)), null);
        ItemStack gravel = new ItemStack(Blocks.field_150351_n);
        ItemStack sand = new ItemStack((Block)Blocks.field_150354_m);
        for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
            CentrifugeManager.addRecipe(energy, new ItemStack(Blocks.field_192444_dS, 2, i), Arrays.asList(gravel, sand, new ItemStack((Item)TFItems.itemDye, 1, 15 - i)), Arrays.asList(100, 100, 10), null);
        }
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.getOre((String)"dustBrass", (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.getOre((String)"dustZinc")), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.getOre((String)"dustCupronickel", (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemMaterial.dustNickel), null);
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackValidatedNBT, CentrifugeRecipe> entry : recipeMap.entrySet()) {
            CentrifugeRecipe tempRecipe = entry.getValue();
            tempMap.put(CentrifugeManager.convertInput(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static CentrifugeRecipe addRecipe(int energy, ItemStack input, List<ItemStack> output, List<Integer> chance, FluidStack fluid) {
        return null;
    }

    public static CentrifugeRecipe addRecipe(int energy, ItemStack input, List<ItemStack> output, FluidStack fluid) {
        if (input.func_190926_b() || output.isEmpty() && fluid == null || output.size() > 4 || energy <= 0 || CentrifugeManager.recipeExists(input)) {
            return null;
        }
        CentrifugeRecipe recipe = new CentrifugeRecipe(input, output, null, fluid, energy);
        recipeMap.put(CentrifugeManager.convertInput(input), recipe);
        return recipe;
    }

    public static CentrifugeRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove(CentrifugeManager.convertInput(input));
    }

    public static ComparableItemStackValidatedNBT convertInput(ItemStack stack) {
        return new ComparableItemStackValidatedNBT(stack, oreValidator);
    }

    static {
        oreValidator.addPrefix("dust");
    }

    public static class CentrifugeRecipe {
        protected ItemStack input;
        protected List<ItemStack> output;
        protected List<Integer> chance;
        protected FluidStack fluid;
        protected int energy;

        CentrifugeRecipe(ItemStack input, @Nullable List<ItemStack> output, @Nullable List<Integer> chance, @Nullable FluidStack fluid, int energy) {
            this.input = input;
            this.output = new ArrayList<ItemStack>();
            if (output != null) {
                this.output.addAll(output);
            }
            this.chance = new ArrayList<Integer>();
            if (chance != null) {
                this.chance.addAll(chance);
            } else {
                for (int i = 0; i < this.output.size(); ++i) {
                    this.chance.add(100);
                }
            }
            this.fluid = fluid;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public List<ItemStack> getOutput() {
            return this.output;
        }

        public List<Integer> getChance() {
            return this.chance;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

