/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.transposer;

import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiTransposer;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TransposerRecipeCategoryExtract
extends TransposerRecipeCategory {
    public static void initialize(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(TransposerRecipeCategoryExtract.getRecipes(guiHelper, registry.getIngredientRegistry()), "thermalexpansion.transposer_extract");
        registry.addRecipeCatalyst((Object)BlockMachine.machineTransposer, new String[]{"thermalexpansion.transposer_extract"});
    }

    public static List<TransposerRecipeWrapper> getRecipes(IGuiHelper guiHelper, IIngredientRegistry ingredientRegistry) {
        ArrayList<TransposerRecipeWrapper> recipes = new ArrayList<TransposerRecipeWrapper>();
        ArrayList potionRecipes = new ArrayList();
        ArrayList splashPotionRecipes = new ArrayList();
        ArrayList lingeringPotionRecipes = new ArrayList();
        return recipes;
    }

    public TransposerRecipeCategoryExtract(IGuiHelper guiHelper) {
        super(guiHelper);
        this.localizedName = this.localizedName + " - " + StringHelper.localize((String)"gui.thermalexpansion.jei.transposer.modeEmpty");
        this.icon = guiHelper.createDrawable(GuiTransposer.TEXTURE, 192, 48, 16, 16);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.transposer_extract";
    }

    public void setRecipe(IRecipeLayout recipeLayout, TransposerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        List fluids = ingredients.getOutputs(FluidStack.class);
        IFocus focus = recipeLayout.getFocus();
        if (focus != null) {
            if (focus.getMode() == IFocus.Mode.INPUT && focus.getValue() instanceof ItemStack) {
                ArrayList<FluidStack> focusFluids = new ArrayList<FluidStack>();
                ItemStack input2 = (ItemStack)focus.getValue();
                FluidStack contained = FluidHelper.getFluidStackFromHandler((ItemStack)input2);
                if (contained != null) {
                    for (FluidStack fluid : (List)fluids.get(0)) {
                        if (!FluidHelper.isFluidEqual((FluidStack)contained, (FluidStack)fluid)) continue;
                        focusFluids.add(fluid);
                    }
                    if (focusFluids.size() != ((List)fluids.get(0)).size()) {
                        fluids = Collections.singletonList(focusFluids);
                    }
                }
            } else if (focus.getMode() == IFocus.Mode.OUTPUT && focus.getValue() instanceof FluidStack) {
                ArrayList<ItemStack> focusInputs = new ArrayList<ItemStack>();
                FluidStack fluid = (FluidStack)focus.getValue();
                for (ItemStack stack : (List)inputs.get(0)) {
                    FluidStack contained = FluidHelper.getFluidStackFromHandler((ItemStack)stack);
                    if (contained != null && !FluidHelper.isFluidEqual((FluidStack)fluid, (FluidStack)contained)) continue;
                    focusInputs.add(stack);
                }
                if (focusInputs.size() != ((List)inputs.get(0)).size()) {
                    inputs = Collections.singletonList(focusInputs);
                }
            }
        }
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        Map fluidIngredients = guiFluidStacks.getGuiIngredients();
        recipeWrapper.setGuiFluids(fluidIngredients);
        guiItemStacks.init(0, true, 30, 10);
        guiItemStacks.init(1, false, 30, 41);
        guiFluidStacks.init(0, false, 103, 1, 16, 60, 1000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, outputs.isEmpty() ? null : (List)outputs.get(0));
        guiFluidStacks.set(0, (List)fluids.get(0));
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 1 && recipeWrapper.chance < 100) {
                tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + recipeWrapper.chance + "%");
            }
        });
        guiFluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (FluidHelper.isPotionFluid((FluidStack)ingredient)) {
                FluidHelper.addPotionTooltip((FluidStack)ingredient, (List)tooltip);
            }
        });
    }
}

