/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.smelter;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiSmelter;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.smelter.SmelterRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class SmelterRecipeCategory
extends BaseRecipeCategory<SmelterRecipeWrapper> {
    public static boolean enable = true;
    protected IDrawableStatic progress;
    protected IDrawableStatic speed;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Machine.Smelter", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new SmelterRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        try {
            IJeiHelpers jeiHelpers = registry.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            registry.addRecipes(SmelterRecipeCategory.getRecipes(guiHelper), "thermalexpansion.smelter");
            registry.addRecipeClickArea(GuiSmelter.class, 79, 34, 24, 16, new String[]{"thermalexpansion.smelter"});
            registry.addRecipeCatalyst((Object)BlockMachine.machineSmelter, new String[]{"thermalexpansion.smelter"});
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Bad/null recipe!", t);
        }
    }

    public static List<SmelterRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<SmelterRecipeWrapper> recipes = new ArrayList<SmelterRecipeWrapper>();
        for (SmelterManager.SmelterRecipe recipe : SmelterManager.getRecipeList()) {
            recipes.add(new SmelterRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public SmelterRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiSmelter.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.smelter.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(0);
        this.speed = Drawables.getDrawables(guiHelper).getScale(4);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.smelter";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 33);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SmelterRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 21, 14);
        guiItemStacks.init(1, true, 45, 14);
        guiItemStacks.init(2, false, 105, 14);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)inputs.get(1));
        guiItemStacks.set(2, (List)outputs.get(0));
        if (outputs.size() > 1) {
            guiItemStacks.init(3, false, 105, 41);
            guiItemStacks.set(3, (List)outputs.get(1));
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 3) {
                    tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + recipeWrapper.chance + "%");
                }
            });
        }
    }
}

