/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.core.ISecurable;
import cofh.api.item.IColorableItem;
import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.gui.container.InventoryContainerItemWrapper;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.filter.ItemFilterWrapper;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemSecurity;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemSatchel
extends ItemMulti
implements IInitializer,
IColorableItem,
IEnchantableItem,
IInventoryContainerItem,
IMultiModeItem {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int VOID = 100;
    public static final int TINT_INDEX_0 = 2;
    public static final int TINT_INDEX_1 = 3;
    public static boolean enable = true;
    public static boolean enableSecurity = true;
    public static ItemStack satchelBasic;
    public static ItemStack satchelHardened;
    public static ItemStack satchelReinforced;
    public static ItemStack satchelSignalum;
    public static ItemStack satchelResonant;
    public static ItemStack satchelVoid;
    public static ItemStack satchelCreative;

    public static ItemStack setDefaultInventoryTag(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74757_a("Accessible", true);
        return container;
    }

    public static boolean needsTag(ItemStack container) {
        return container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Accessible");
    }

    public ItemSatchel() {
        super("thermalexpansion");
        this.func_77655_b("satchel");
        this.func_77637_a(ThermalExpansion.tabTools);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)stack, tooltip);
        if (ItemSatchel.isVoid(stack)) {
            tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.satchel.a.v"));
            tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.satchel.a.2"));
            tooltip.add(StringHelper.localizeFormat((String)("info.thermalexpansion.satchel.b." + this.getMode(stack)), (Object[])new Object[0]));
            return;
        }
        if (ItemSatchel.isCreative((ItemStack)stack)) {
            tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.satchel.a.c"));
            tooltip.add(StringHelper.localize((String)"info.thermalexpansion.satchel.a.1"));
            ItemHelper.addInventoryInformation((ItemStack)stack, tooltip);
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.satchel.a.0"));
        tooltip.add(StringHelper.localize((String)"info.thermalexpansion.satchel.a.1"));
        tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.satchel.a.2"));
        tooltip.add(StringHelper.localizeFormat((String)("info.thermalexpansion.satchel.b." + this.getMode(stack)), (Object[])new Object[0]));
        ItemHelper.addInventoryInformation((ItemStack)stack, tooltip);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable && this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)ItemSatchel.setDefaultInventoryTag(new ItemStack((Item)this, 1, metadata)));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)ItemSatchel.setDefaultInventoryTag(new ItemStack((Item)this, 1, metadata)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemSatchel.isVoid(stack) && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("Random")) {
            stack.func_77978_p().func_82580_o("Random");
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return !ItemSatchel.isCreative((ItemStack)stack) && !ItemSatchel.isVoid(stack);
    }

    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 10;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (ItemSatchel.needsTag(stack)) {
            ItemSatchel.setDefaultInventoryTag(stack);
        }
        if (ServerHelper.isServerWorld((World)world)) {
            if (SecurityHelper.isSecure((ItemStack)stack) && SecurityHelper.isDefaultUUID((UUID)SecurityHelper.getOwner((ItemStack)stack).getId())) {
                SecurityHelper.setOwner((ItemStack)stack, (GameProfile)player.func_146103_bH());
                ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.item.success", new Object[0]));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (ItemSatchel.canPlayerAccess((ItemStack)stack, (EntityPlayer)player)) {
                if (player.func_70093_af() && ItemHelper.getItemDamage((ItemStack)stack) != 32000) {
                    player.openGui((Object)ThermalExpansion.instance, 17, world, 0, 0, 0);
                } else {
                    player.openGui((Object)ThermalExpansion.instance, 16, world, 0, 0, 0);
                }
            } else if (SecurityHelper.isSecure((ItemStack)stack)) {
                ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.warning", new Object[]{SecurityHelper.getOwnerName((ItemStack)stack)}));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile;
        if (world.func_175623_d(pos)) {
            return EnumActionResult.PASS;
        }
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && ItemSatchel.canPlayerAccess((ItemStack)stack, (EntityPlayer)player) && (tile = world.func_175625_s(pos)) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (ServerHelper.isServerWorld((World)world)) {
                this.emptyInventoryIntoTarget(stack, cap);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void emptyInventoryIntoTarget(ItemStack stack, IItemHandler target) {
        InventoryContainerItemWrapper wrapper = new InventoryContainerItemWrapper(stack);
        for (int i = 0; i < this.getSizeInventory(stack); ++i) {
            ItemStack slot = wrapper.func_70301_a(i);
            if (slot.func_190926_b()) continue;
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)slot, (boolean)false);
            if (ItemSatchel.isCreative((ItemStack)stack)) continue;
            wrapper.func_70299_a(i, remainder);
        }
        wrapper.func_70296_d();
    }

    public static boolean hasHoldingEnchant(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack) > 0;
    }

    public static boolean isVoid(ItemStack stack) {
        return ItemHelper.getItemDamage((ItemStack)stack) == 100;
    }

    public static int getLevel(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemSatchel.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
    }

    public static int getStorageIndex(ItemStack stack) {
        if (ItemSatchel.isCreative((ItemStack)stack) || ItemSatchel.isVoid(stack) || !typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int level = ((TypeEntry)ItemSatchel.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return Math.min(1 + level + enchant, CoreProps.STORAGE_SIZE.length - 1);
    }

    public static int getFilterSize(ItemStack stack) {
        return CoreProps.FILTER_SIZE[ItemSatchel.getLevel(stack)];
    }

    public static boolean onItemPickup(EntityItemPickupEvent event, ItemStack stack) {
        if (!ItemSatchel.canPlayerAccess((ItemStack)stack, (EntityPlayer)event.getEntityPlayer()) || ((ItemSatchel)stack.func_77973_b()).getMode(stack) <= 0 || ItemSatchel.isCreative((ItemStack)stack)) {
            return false;
        }
        ItemFilterWrapper wrapper = new ItemFilterWrapper(stack, ItemSatchel.getFilterSize(stack));
        ItemStack eventItem = event.getItem().func_92059_d();
        if (wrapper.getFilter().matches(eventItem)) {
            if (ItemSatchel.isVoid(stack)) {
                eventItem.func_190920_e(0);
                stack.func_190915_d(5);
                EntityPlayer player = event.getEntityPlayer();
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.7f + 1.0f);
                stack.func_77978_p().func_74768_a("Random", MathHelper.RANDOM.nextInt());
                return true;
            }
            if (!(eventItem.func_77973_b() instanceof IInventoryContainerItem) || ((IInventoryContainerItem)eventItem.func_77973_b()).getSizeInventory(stack) <= 0) {
                int count = eventItem.func_190916_E();
                InventoryContainerItemWrapper inv = new InventoryContainerItemWrapper(stack);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack slot = inv.func_70301_a(i);
                    if (slot.func_190926_b()) {
                        inv.func_70299_a(i, eventItem.func_77946_l());
                        eventItem.func_190920_e(Math.max(eventItem.func_190916_E() - inv.func_70297_j_(), 0));
                    } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)eventItem, (ItemStack)slot)) {
                        int fill = slot.func_77976_d() - slot.func_190916_E();
                        if (fill > eventItem.func_190916_E()) {
                            slot.func_190920_e(slot.func_190916_E() + eventItem.func_190916_E());
                        } else {
                            slot.func_190920_e(slot.func_77976_d());
                        }
                        eventItem.func_77979_a(fill);
                    }
                    if (eventItem.func_190926_b()) break;
                }
                if (eventItem.func_190916_E() != count) {
                    stack.func_190915_d(5);
                    EntityPlayer player = event.getEntityPlayer();
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    inv.func_70296_d();
                }
            }
        }
        return eventItem.func_190926_b();
    }

    public int colorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == 2 && ColorHelper.hasColor0((ItemStack)stack)) {
            return ColorHelper.getColor0((ItemStack)stack);
        }
        if (tintIndex == 3 && ColorHelper.hasColor1((ItemStack)stack)) {
            return ColorHelper.getColor1((ItemStack)stack);
        }
        return 0xFFFFFF;
    }

    public int getMaxColorIndex(ItemStack stack) {
        return 1;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public int getSizeInventory(ItemStack container) {
        return CoreProps.STORAGE_SIZE[ItemSatchel.getStorageIndex(container)];
    }

    public int getNumModes(ItemStack stack) {
        return ItemSatchel.isCreative((ItemStack)stack) ? 1 : 2;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.4f, 0.8f + 0.4f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalexpansion.satchel.c." + this.getMode(stack), new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), String.format("access=%s,color0=%s,color1=%s,type=%s", SecurityHelper.getAccess((ItemStack)stack).toString().toLowerCase(Locale.US), ColorHelper.hasColor0((ItemStack)stack) ? 1 : 0, ColorHelper.hasColor1((ItemStack)stack) ? 1 : 0, ((TypeEntry)ItemSatchel.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name)));
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int access = 0; access < ISecurable.AccessMode.values().length; ++access) {
                for (int color0 = 0; color0 < 2; ++color0) {
                    for (int color1 = 0; color1 < 2; ++color1) {
                        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("access=%s,color0=%s,color1=%s,type=%s", ISecurable.AccessMode.values()[access].toString().toLowerCase(Locale.US), color0, color1, ((ItemMulti.ItemEntry)entry.getValue()).name))});
                    }
                }
            }
        }
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("satchel"));
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        ItemSatchel.config();
        satchelBasic = this.addEntryItem(0, "standard0", 0, EnumRarity.COMMON);
        satchelHardened = this.addEntryItem(1, "standard1", 1, EnumRarity.COMMON);
        satchelReinforced = this.addEntryItem(2, "standard2", 2, EnumRarity.UNCOMMON);
        satchelSignalum = this.addEntryItem(3, "standard3", 3, EnumRarity.UNCOMMON);
        satchelResonant = this.addEntryItem(4, "standard4", 4, EnumRarity.RARE);
        satchelVoid = this.addEntryItem(100, "void", 4, EnumRarity.UNCOMMON);
        satchelCreative = this.addEntryItem(32000, "creative", 4, EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)satchelBasic, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotTin", Character.valueOf('R'), Items.field_151116_aA, Character.valueOf('X'), "blockWool"});
        RecipeHelper.addShapedRecipe((ItemStack)satchelBasic, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotTin", Character.valueOf('R'), "blockRockwool", Character.valueOf('X'), "blockWool"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)satchelHardened, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "nuggetTin", Character.valueOf('X'), satchelBasic});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)satchelReinforced, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "nuggetInvar", Character.valueOf('X'), satchelHardened});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)satchelSignalum, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "nuggetElectrum", Character.valueOf('X'), satchelReinforced});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)satchelResonant, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "nuggetSignalum", Character.valueOf('X'), satchelSignalum});
        RecipeHelper.addShapedRecipe((ItemStack)satchelVoid, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "cobblestone", Character.valueOf('R'), Items.field_151116_aA, Character.valueOf('X'), Items.field_151129_at});
        RecipeHelper.addShapedRecipe((ItemStack)satchelVoid, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "cobblestone", Character.valueOf('R'), "blockRockwool", Character.valueOf('X'), Items.field_151129_at});
        RecipeHelper.addShapelessSecureRecipe((ItemStack)satchelBasic, (Object[])new Object[]{satchelBasic, ItemSecurity.lock});
        RecipeHelper.addShapelessSecureRecipe((ItemStack)satchelHardened, (Object[])new Object[]{satchelHardened, ItemSecurity.lock});
        RecipeHelper.addShapelessSecureRecipe((ItemStack)satchelReinforced, (Object[])new Object[]{satchelReinforced, ItemSecurity.lock});
        RecipeHelper.addShapelessSecureRecipe((ItemStack)satchelSignalum, (Object[])new Object[]{satchelSignalum, ItemSecurity.lock});
        RecipeHelper.addShapelessSecureRecipe((ItemStack)satchelResonant, (Object[])new Object[]{satchelResonant, ItemSecurity.lock});
        RecipeHelper.addColorRecipe((ItemStack)satchelBasic, (Object[])new Object[]{satchelBasic, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelHardened, (Object[])new Object[]{satchelHardened, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelReinforced, (Object[])new Object[]{satchelReinforced, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelSignalum, (Object[])new Object[]{satchelSignalum, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelResonant, (Object[])new Object[]{satchelResonant, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelBasic, (Object[])new Object[]{satchelBasic, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelHardened, (Object[])new Object[]{satchelHardened, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelReinforced, (Object[])new Object[]{satchelReinforced, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelSignalum, (Object[])new Object[]{satchelSignalum, "dye", "dye"});
        RecipeHelper.addColorRecipe((ItemStack)satchelResonant, (Object[])new Object[]{satchelResonant, "dye", "dye"});
        RecipeHelper.addColorRemoveRecipe((ItemStack)satchelBasic, (Object[])new Object[]{satchelBasic});
        RecipeHelper.addColorRemoveRecipe((ItemStack)satchelHardened, (Object[])new Object[]{satchelHardened});
        RecipeHelper.addColorRemoveRecipe((ItemStack)satchelReinforced, (Object[])new Object[]{satchelReinforced});
        RecipeHelper.addColorRemoveRecipe((ItemStack)satchelSignalum, (Object[])new Object[]{satchelSignalum});
        RecipeHelper.addColorRemoveRecipe((ItemStack)satchelResonant, (Object[])new Object[]{satchelResonant});
        return true;
    }

    private static void config() {
        String category = "Item.Satchel";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", enable);
    }

    private void addTypeEntry(int metadata, String name, int level) {
        typeMap.put(metadata, (Object)new TypeEntry(name, level));
    }

    private ItemStack addEntryItem(int metadata, String name, int level, EnumRarity rarity) {
        this.addTypeEntry(metadata, name, level);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int level;

        TypeEntry(String name, int level) {
            this.name = name;
            this.level = level;
        }
    }
}

