/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.forge;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.util.NBTAction;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class HandleRegistryEntry
implements IHandler<IForgeRegistryEntry> {
    private static final String REGISTRY = "*R";

    @Override
    public Class<?> getRootType() {
        return IForgeRegistryEntry.class;
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, IForgeRegistryEntry object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        ResourceLocation loc = object.getRegistryName();
        if (loc == null) {
            throw new IllegalArgumentException("Registry entry must be registered to be stored: " + object);
        }
        nbt.func_74778_a(name, loc.toString());
        IForgeRegistry forgeRegistry = GameRegistry.findRegistry((Class)object.getRegistryType());
        if (forgeRegistry == null) {
            throw new IllegalArgumentException("Registry entry's registry must be registered to be stored: " + object);
        }
        nbt.func_74778_a(name + REGISTRY, RegistryManager.ACTIVE.getName(forgeRegistry).toString());
        return true;
    }

    @Override
    @Nullable
    public IForgeRegistryEntry read(Registry registry, Set<NBTAction> phase, NBTTagCompound nbt, Type type, String name, @Nullable IForgeRegistryEntry object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name) && nbt.func_74764_b(name + REGISTRY)) {
            ResourceLocation registryName = new ResourceLocation(nbt.func_74779_i(name + REGISTRY));
            ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (forgeRegistry == null) {
                throw new IllegalArgumentException("Registry entry's registry must be registered to be read: " + registryName);
            }
            ResourceLocation rl = new ResourceLocation(nbt.func_74779_i(name));
            IForgeRegistryEntry ret = forgeRegistry.getValue(rl);
            return ret;
        }
        return object;
    }
}

