/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.items;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.annotations.AutoRegisterItem;
import net.ndrei.teslacorelib.items.CoreItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterItem(configFlags={"registerBattery"})
@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux", striprefs=true)
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0017J\"\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0012\u0010\u0015\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0017J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0017J\u001e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0017J\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\"\u0010!\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0017\u00a8\u0006#"}, d2={"Lnet/ndrei/teslacorelib/items/TeslaBattery;", "Lnet/ndrei/teslacorelib/items/CoreItem;", "Lcofh/redstoneflux/api/IEnergyContainerItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "extractEnergy", "", "container", "maxExtract", "simulate", "", "getEnergyStored", "getItemStackLimit", "getMaxEnergyStored", "getSubItems", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "subItems", "Lnet/minecraft/util/NonNullList;", "initCapabilities", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "receiveEnergy", "maxReceive", "tesla-core-lib"})
public final class TeslaBattery
extends CoreItem
implements IEnergyContainerItem {
    public static final TeslaBattery INSTANCE;

    @Nullable
    public ICapabilityProvider initCapabilities(@Nullable ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilityProvider(){
            private EnergyStorage storage;

            @Nullable
            public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
                Object object;
                Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
                if (Intrinsics.areEqual(capability, (Object)CapabilityEnergy.ENERGY)) {
                    EnergyStorage energyStorage = this.storage;
                    if (!(energyStorage instanceof Object)) {
                        energyStorage = null;
                    }
                    object = energyStorage;
                } else {
                    object = null;
                }
                return (T)object;
            }

            public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
                Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
                return Intrinsics.areEqual(capability, (Object)CapabilityEnergy.ENERGY);
            }

            public void deserializeNBT(@Nullable NBTTagCompound nbt) {
                int capacity = nbt != null && nbt.func_150297_b("capacity", 3) ? nbt.func_74762_e("capacity") : 10000;
                int stored = nbt != null && nbt.func_150297_b("stored", 3) ? nbt.func_74762_e("stored") : 0;
                int inputRate = 100;
                int outputRate = 100;
                this.storage = new EnergyStorage(capacity, inputRate, outputRate, stored);
            }

            @NotNull
            public NBTTagCompound serializeNBT() {
                NBTTagCompound nBTTagCompound;
                NBTTagCompound it = nBTTagCompound = new NBTTagCompound();
                it.func_74768_a("capacity", this.storage.getMaxEnergyStored());
                it.func_74768_a("stored", this.storage.getEnergyStored());
                return nBTTagCompound;
            }
            {
                this.storage = new EnergyStorage(10000, 100, 100);
            }
        };
    }

    public int getItemStackLimit(@Nullable ItemStack stack) {
        ItemStack itemStack = stack;
        IEnergyStorage energy = itemStack != null ? (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null) : null;
        return energy == null || energy.getEnergyStored() == 0 ? 16 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nullable ItemStack stack, @Nullable World worldIn, @Nullable List<String> tooltip, @Nullable ITooltipFlag flagIn) {
        IEnergyStorage energy;
        ItemStack itemStack = stack;
        IEnergyStorage iEnergyStorage = energy = itemStack != null ? (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null) : null;
        if (energy != null) {
            if (energy.getEnergyStored() > 0) {
                List<String> list = tooltip;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                list.add(ChatFormatting.AQUA.toString() + "Power: " + energy.getEnergyStored() + ChatFormatting.RESET + " of " + ChatFormatting.AQUA + energy.getMaxEnergyStored());
            } else {
                List<String> list = tooltip;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                list.add(ChatFormatting.RED.toString() + "EMPTY!");
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> subItems) {
        Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
        Intrinsics.checkParameterIsNotNull(subItems, (String)"subItems");
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            ItemStack full = new ItemStack((Item)this);
            IEnergyStorage energy = (IEnergyStorage)full.getCapability(CapabilityEnergy.ENERGY, null);
            if (energy != null) {
                int cycle = 0;
                while (energy.canReceive() && energy.getMaxEnergyStored() > energy.getEnergyStored() && cycle++ < 100) {
                    energy.receiveEnergy(energy.getMaxEnergyStored() - energy.getEnergyStored(), false);
                }
            }
            subItems.add((Object)full);
        }
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(@Nullable ItemStack container) {
        ItemStack energy;
        ItemStack itemStack = container;
        if (itemStack == null || (itemStack = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null)) == null) {
            return 0;
        }
        ItemStack itemStack2 = energy = itemStack;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"energy");
        return itemStack2.getMaxEnergyStored();
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(@Nullable ItemStack container) {
        ItemStack energy;
        ItemStack itemStack = container;
        if (itemStack == null || (itemStack = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null)) == null) {
            return 0;
        }
        ItemStack itemStack2 = energy = itemStack;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"energy");
        return itemStack2.getEnergyStored();
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(@Nullable ItemStack container, int maxExtract, boolean simulate) {
        ItemStack itemStack = container;
        if (itemStack == null || (itemStack = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null)) == null) {
            return 0;
        }
        ItemStack energy = itemStack;
        return energy.extractEnergy(maxExtract, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(@Nullable ItemStack container, int maxReceive, boolean simulate) {
        ItemStack itemStack = container;
        if (itemStack == null || (itemStack = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null)) == null) {
            return 0;
        }
        ItemStack energy = itemStack;
        return energy.receiveEnergy(maxReceive, simulate);
    }

    private TeslaBattery() {
        super("battery");
    }

    static {
        TeslaBattery teslaBattery;
        INSTANCE = teslaBattery = new TeslaBattery();
        super.func_77627_a(true).func_185043_a(new ResourceLocation("power"), (IItemPropertyGetter)1.INSTANCE);
    }
}

