/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability.helpers;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHelper {
    private static final HashMap<String, ItemStack> testTools = new HashMap();

    public static String getEffectiveToolOf(World world, BlockPos blockPos, Block block, IBlockState blockState) {
        float hardness;
        String effectiveTool = block.getHarvestTool(blockState);
        if (effectiveTool == null && (hardness = block.func_176195_g(blockState, world, blockPos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> testToolEntry : testTools.entrySet()) {
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || !(testTool.func_77973_b() instanceof ItemTool) || !testTool.func_150998_b(blockState)) continue;
                effectiveTool = testToolEntry.getKey();
                break;
            }
        }
        if (effectiveTool == "pickaxe" || effectiveTool == "axe" || effectiveTool == "shovel") {
            return "Paxel";
        }
        if (effectiveTool == null) {
            return null;
        }
        return effectiveTool.substring(0, 1).toUpperCase() + effectiveTool.substring(1);
    }

    public static boolean isBlockUnbreakable(Block block, World world, BlockPos blockPos, IBlockState blockState) {
        return block.func_176195_g(blockState, world, blockPos) == -1.0f;
    }

    public static boolean isAdventureModeAndBlockIsUnbreakable(EntityPlayer player, Block block) {
        return false;
    }

    public static boolean canHarvestBlock(Block block, EntityPlayer player, IBlockState state) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        String tool = block.getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    static {
        testTools.put("pickaxe", new ItemStack(Items.field_151039_o));
        testTools.put("shovel", new ItemStack(Items.field_151038_n));
        testTools.put("axe", new ItemStack(Items.field_151053_p));
    }
}

