/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import crafttweaker.api.data.IData;
import java.util.Optional;
import java.util.function.Consumer;
import leviathan143.loottweaker.common.lib.JsonConverter;

public class DataParser {
    private final Gson gsonInstance;
    private final Consumer<JsonSyntaxException> errorHandler;

    public DataParser(Gson gsonInstance, Consumer<JsonSyntaxException> errorHandler) {
        this.gsonInstance = gsonInstance;
        this.errorHandler = errorHandler;
    }

    public <T> Optional<T> parse(IData data, Class<T> clazz) {
        try {
            return Optional.of(this.gsonInstance.fromJson(JsonConverter.from(data), clazz));
        }
        catch (JsonSyntaxException e) {
            this.errorHandler.accept(e);
            return Optional.empty();
        }
    }
}

