/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.command;

import java.io.File;
import leviathan143.loottweaker.common.command.Subcommand;
import leviathan143.loottweaker.common.darkmagic.EntityLivingAccessors;
import leviathan143.loottweaker.common.lib.LootTableDumper;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.ILootContainer;

public class SubcommandDumpTargetsLootTable
implements Subcommand {
    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender instanceof Entity) {
            ResourceLocation tableId = null;
            RayTraceResult target = SubcommandDumpTargetsLootTable.getLookTarget((Entity)sender, 8.0);
            switch (target.field_72313_a) {
                case BLOCK: {
                    TileEntity te = sender.func_130014_f_().func_175625_s(target.func_178782_a());
                    if (te instanceof ILootContainer) {
                        tableId = ((ILootContainer)te).func_184276_b();
                        break;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.noTable", new Object[0]));
                    break;
                }
                case ENTITY: {
                    if (target.field_72308_g instanceof EntityLiving) {
                        tableId = EntityLivingAccessors.getLootTable((EntityLiving)target.field_72308_g);
                        break;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.noTable", new Object[0]));
                    break;
                }
                case MISS: {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.noTarget", new Object[0]));
                    return;
                }
                default: {
                    return;
                }
            }
            if (tableId == null) {
                return;
            }
            File dump = LootTableDumper.DEFAULT.dump(sender.func_130014_f_(), tableId);
            if (!server.func_71262_S()) {
                SubcommandDumpTargetsLootTable.linkDumpFileInChat(sender, dump, tableId);
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.senderNotEntity", new Object[0]));
        }
    }

    private static RayTraceResult getLookTarget(Entity observer, double distance) {
        Vec3d eyePos = observer.func_174824_e(1.0f);
        Vec3d look = observer.func_70676_i(1.0f);
        Vec3d lookTarget = eyePos.func_72441_c(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        World world = observer.func_130014_f_();
        RayTraceResult result = world.func_72933_a(eyePos, lookTarget);
        double blockHitDistance = 0.0;
        if (result != null) {
            blockHitDistance = result.field_72307_f.func_72438_d(eyePos);
        }
        AxisAlignedBB entitySearchArea = new AxisAlignedBB(eyePos.field_72450_a, eyePos.field_72448_b, eyePos.field_72449_c, lookTarget.field_72450_a, lookTarget.field_72448_b, lookTarget.field_72449_c);
        Entity hitEntity = null;
        double entityHitDistance = 0.0;
        for (Entity candidate : world.func_175674_a(observer, entitySearchArea, EntitySelectors.field_180132_d)) {
            double distance1;
            AxisAlignedBB collisionBB = candidate.func_174813_aQ().func_186662_g((double)candidate.func_70111_Y());
            RayTraceResult intercept = collisionBB.func_72327_a(eyePos, lookTarget);
            if (intercept == null || !((distance1 = eyePos.func_72438_d(intercept.field_72307_f)) < blockHitDistance) && blockHitDistance != 0.0 || !(distance1 < entityHitDistance) && entityHitDistance != 0.0) continue;
            entityHitDistance = distance1;
            hitEntity = candidate;
        }
        if (hitEntity != null) {
            result = new RayTraceResult(hitEntity, hitEntity.func_174791_d());
        }
        if (result == null) {
            result = new RayTraceResult(RayTraceResult.Type.MISS, lookTarget, null, new BlockPos(lookTarget));
        }
        return result;
    }

    private static void linkDumpFileInChat(ICommandSender sender, File dump, ResourceLocation tableLoc) {
        TextComponentTranslation message = new TextComponentTranslation("loottweaker.commands.dump.dumpLink", new Object[]{tableLoc});
        TextComponentString link = new TextComponentString(dump.toString());
        link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, dump.toString())).func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.AQUA);
        sender.func_145747_a(message.func_150257_a((ITextComponent)link));
    }
}

