/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common;

import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import java.util.Map;
import leviathan143.loottweaker.common.CTLoggingErrorHandler;
import leviathan143.loottweaker.common.DeprecationWarningManager;
import leviathan143.loottweaker.common.LTConfig;
import leviathan143.loottweaker.common.command.CommandLootTables;
import leviathan143.loottweaker.common.zenscript.LootTweakerContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="loottweaker", name="LootTweaker", version="0.1.7", dependencies="required-after:crafttweaker; before:jeresources; required:forge@[14.23.5.2779,);", acceptedMinecraftVersions="[1.12.2]")
public class LootTweaker {
    public static final String MODNAME = "LootTweaker";
    public static final String MODID = "loottweaker";
    public static final String VERSION = "0.1.7";
    public static final String DEPENDENCIES = "required-after:crafttweaker; before:jeresources; required:forge@[14.23.5.2779,);";
    public static final LootTweakerContext CONTEXT = new LootTweakerContext(new CTLoggingErrorHandler());
    private static final Logger LOGGER = LogManager.getLogger((String)"LootTweaker");

    @NetworkCheckHandler
    public boolean networkCheck(Map<String, String> modVersions, Side remoteSide) {
        if (!modVersions.containsKey("forge")) {
            return false;
        }
        String remoteLTVersion = modVersions.get(MODID);
        if (remoteLTVersion == null) {
            if (remoteSide == Side.CLIENT) {
                LOGGER.info("Accepted non-existent client LootTweaker install");
                return true;
            }
            LOGGER.info("Rejected non-existent server LootTweaker install");
            return false;
        }
        if (!remoteLTVersion.equals(VERSION)) {
            LOGGER.info("Rejected {} LootTweaker install because its version {} differs from local version {}", (Object)remoteSide.name().toLowerCase(), (Object)remoteLTVersion, (Object)VERSION);
            return false;
        }
        return true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LTConfig.onLoad();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CTChatCommand.registerCommand((CraftTweakerCommand)new CommandLootTables());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        DeprecationWarningManager.printDeprecationWarnings();
    }
}

