/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tweaker;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.tweaker.NBTConverter;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="extrautilities2.Tweaker.InterModCommsHandler")
public class InterModCommsHandler {
    public static boolean checkEnqueuing() {
        if (Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            CraftTweakerAPI.logError((String)"IMC Message is being sent too late.");
            return false;
        }
        return true;
    }

    @ZenMethod
    public static boolean sendMessageString(String mod, String key, String message) {
        return InterModCommsHandler.checkEnqueuing() && FMLInterModComms.sendMessage((String)mod, (String)key, (String)message);
    }

    @ZenMethod
    public static boolean sendMessageItemStack(String mod, String key, IItemStack stack) {
        return InterModCommsHandler.checkEnqueuing() && FMLInterModComms.sendMessage((String)mod, (String)key, (ItemStack)((ItemStack)stack.getInternal()));
    }

    @ZenMethod
    public static boolean sendMessageNBT(String mod, String key, DataMap dataMap) {
        NBTTagCompound nbtData = (NBTTagCompound)NBTConverter.from((IData)dataMap);
        return InterModCommsHandler.checkEnqueuing() && FMLInterModComms.sendMessage((String)mod, (String)key, (NBTTagCompound)nbtData);
    }

    @ZenMethod
    public static boolean sendMessageResourceLocation(String mod, String key, String resourceLocation) {
        return InterModCommsHandler.checkEnqueuing() && FMLInterModComms.sendMessage((String)mod, (String)key, (ResourceLocation)new ResourceLocation(resourceLocation));
    }

    @ZenMethod
    public static void sendRuntimeMessageString(String mod, String key, String message) {
        FMLInterModComms.sendRuntimeMessage((Object)ExtraUtils2.instance, (String)mod, (String)key, (String)message);
    }

    @ZenMethod
    public static void sendRuntimeMessageItemStack(String mod, String key, IItemStack stack) {
        FMLInterModComms.sendRuntimeMessage((Object)ExtraUtils2.instance, (String)mod, (String)key, (ItemStack)((ItemStack)stack.getInternal()));
    }

    @ZenMethod
    public static void sendRuntimeMessageNBT(String mod, String key, DataMap dataMap) {
        NBTTagCompound nbtData = (NBTTagCompound)NBTConverter.from((IData)dataMap);
        FMLInterModComms.sendRuntimeMessage((Object)ExtraUtils2.instance, (String)mod, (String)key, (NBTTagCompound)nbtData);
    }

    @ZenMethod
    public static void sendRuntimeMessageResourceLocation(String mod, String key, String resourceLocation) {
        FMLInterModComms.sendRuntimeMessage((Object)ExtraUtils2.instance, (String)mod, (String)key, (ResourceLocation)new ResourceLocation(resourceLocation));
    }
}

