/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.rwtema.extrautils2.quarry.TileQuarry;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileQuarryProxy
extends XUTile {
    NBTSerializable.NBTEnum<EnumFacing> facing = this.registerNBT("facing", new NBTSerializable.NBTEnum<EnumFacing>(EnumFacing.DOWN));
    Boolean powered = null;
    private final ItemStackHandler inventory = new ItemStackHandler(1);

    public TileQuarryProxy() {
    }

    public TileQuarryProxy(EnumFacing facing) {
        this.facing.value = facing;
    }

    @Nullable
    public TileQuarry getParent() {
        EnumFacing value = (EnumFacing)this.facing.value;
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(value));
        if (tile instanceof TileQuarry) {
            return (TileQuarry)tile;
        }
        return null;
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.getEnergyHandler();
    }

    public IEnergyStorage getEnergyHandler() {
        TileQuarry parent = this.getParent();
        if (parent != null) {
            return (IEnergyStorage)parent.getCapability(CapabilityEnergy.ENERGY, ((EnumFacing)this.facing.value).func_176734_d());
        }
        return null;
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.powered = worldIn.func_175687_A(pos) > 0;
    }

    public boolean isPowered() {
        if (this.powered == null) {
            this.powered = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        }
        return this.powered;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Object cap;
            TileEntity adjacentTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(((EnumFacing)this.facing.value).func_176734_d()));
            if (adjacentTile != null && (cap = adjacentTile.getCapability(capability, (EnumFacing)this.facing.value)) != null) {
                return (T)cap;
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.getEnergyHandler();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
    }
}

