/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.potion;

import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.potion.XUPotion;
import com.rwtema.extrautils2.utils.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionsHelper {
    public static final List<ItemStack> splash_potions = new ArrayList<ItemStack>();
    public static final List<ItemStack> regular_potions = new ArrayList<ItemStack>();
    public static final List<ItemStack> lingering_potions = new ArrayList<ItemStack>();
    public static final List<ItemStack> potions = new ArrayList<ItemStack>();

    public static void addSimplePotionKeys(String key, String name) {
        Lang.translate("effect." + key, "" + name);
        Lang.translate("potion.effect." + key, "Potion of " + name);
        Lang.translate("lingering_potion.effect." + key, "Lingering Potion of " + name);
        Lang.translate("splash_potion.effect." + key, "Splash Potion of " + name);
        Lang.translate("tipped_arrow.effect." + key, "Arrow of " + name);
    }

    public static void addExplicitDerivedRecipes(PotionType type) {
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)type), (ItemStack)new ItemStack(Items.field_151016_H), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)type));
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)type), (ItemStack)new ItemStack(Items.field_185157_bK), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)type));
    }

    public static PotionType newGenericPotion(String s) {
        String key = Lang.stripText(s);
        Lang.translate("potion.effect." + key, s + " Potion");
        Lang.translate("lingering_potion.effect." + key, s + " Lingering Potion");
        Lang.translate("splash_potion.effect." + key, s + " Splash Potion");
        Lang.translate("tipped_arrow.effect." + key, "Tipped Arrow");
        PotionType type = new PotionType(new PotionEffect[0]);
        type.setRegistryName(new ResourceLocation("extrautils2", key));
        CompatHelper112.register(type);
        return type;
    }

    public static PotionType registerPotionType(PotionEffect potionEffect) {
        Potion potion = potionEffect.func_188419_a();
        String name = potion.func_76393_a().substring("effect.".length());
        PotionsHelper.addSimplePotionKeys(name, ((XUPotion)potion).xuName);
        return PotionsHelper.registerPotionType(potionEffect, name);
    }

    public static PotionType registerDerivedPotionType(PotionEffect potionEffect, PotionType base, String suffix) {
        String resourcePathIn = base.getRegistryName().func_110623_a() + suffix;
        PotionsHelper.addSimplePotionKeys(resourcePathIn, ((XUPotion)potionEffect.func_188419_a()).xuName);
        return PotionsHelper.registerPotionType(potionEffect, resourcePathIn);
    }

    public static void registerPotion(XUPotion potion, String tooltip) {
        Lang.translate(potion.func_76393_a(), potion.xuName);
        potion.setRegistryName(new ResourceLocation("extrautils2", potion.func_76393_a()));
        CompatHelper112.register(potion);
        TooltipHandler.tooltips.put(potion, tooltip);
    }

    public static PotionType registerPotionType(PotionEffect potionEffect, String resourcePathIn) {
        PotionType type = new PotionType(new PotionEffect[]{potionEffect});
        type.setRegistryName(new ResourceLocation("extrautils2", resourcePathIn));
        CompatHelper112.register(type);
        PotionsHelper.addExplicitDerivedRecipes(type);
        return type;
    }

    public static PotionType getVanillaType(String name) {
        return (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation(name));
    }

    public static PotionType getAwkwardPotionType() {
        return PotionsHelper.getVanillaType("awkward");
    }

    public static void serverStart() {
        potions.clear();
        regular_potions.clear();
        splash_potions.clear();
        lingering_potions.clear();
        for (ResourceLocation resourceLocation : PotionType.field_185176_a.func_148742_b()) {
            PotionType type = (PotionType)PotionType.field_185176_a.func_82594_a((Object)resourceLocation);
            regular_potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)type));
            splash_potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)type));
            lingering_potions.add(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)type));
        }
        potions.addAll(regular_potions);
        potions.addAll(splash_potions);
        potions.addAll(lingering_potions);
    }

    public static class TooltipHandler {
        public static HashMap<Potion, String> tooltips = new HashMap();

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void addPotionTooltips(ItemTooltipEvent event) {
            PotionEffect effect;
            String s;
            ItemStack stack = event.getItemStack();
            if (!stack.func_77942_o()) {
                return;
            }
            List list = PotionUtils.func_185189_a((ItemStack)stack);
            if (list.size() == 1 && (s = tooltips.get((effect = (PotionEffect)list.get(0)).func_188419_a())) != null) {
                for (String s1 : s.split("\\n")) {
                    event.getToolTip().add(s1);
                }
            }
        }

        static {
            MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        }
    }
}

