/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.blocks.LuxColors;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.client.GLStateAttributes;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLuxSaber
extends ItemSword
implements IXUItem {
    public static final int ENERGY_PER_HIT = 200;
    public static final int NUM_HITS = 200;
    public static final float OFFSET = 0.05f;
    @Nonnull
    public static final Item.ToolMaterial material = (Item.ToolMaterial)Validate.notNull((Object)EnumHelper.addToolMaterial((String)"LuxSaber", (int)6, (int)2048, (float)5.0f, (float)7.0f, (int)15));
    public static final UUID UUID = java.util.UUID.fromString("8126703D-7BDC-4E0A-98C6-C8FD511FE3A8");
    final WeakHashMap<ItemStack, Float> stackMap = new WeakHashMap();
    final ThreadLocal<Boolean> bladeOnly = ThreadLocal.withInitial(() -> false);
    @SideOnly(value=Side.CLIENT)
    ItemCameraTransforms.TransformType[] transformTypes;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite blank;

    public ItemLuxSaber() {
        super(material);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < LuxColors.values().length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
                ItemStack stack = new ItemStack((Item)this, 1, i);
                XUItemEnergyStorage xuItemEnergyStorage = (XUItemEnergyStorage)Validate.notNull((Object)stack.getCapability(CapabilityEnergy.ENERGY, null));
                xuItemEnergyStorage.setEnergyStored(xuItemEnergyStorage.getMaxEnergyStored());
                items.add((Object)stack);
            }
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            IEnergyStorage storage = (IEnergyStorage)Validate.notNull((Object)stack.getCapability(CapabilityEnergy.ENERGY, null));
            return 1.0 - (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored();
        }
        return super.getDurabilityForDisplay(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return LuxColors.values()[stack.func_77960_j() % LuxColors.values().length].color;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        this.transformTypes = new ItemCameraTransforms.TransformType[]{ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND};
        Textures.register("luxsaber", "blank");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createModel(final int metadata) {
        EnumMap<ItemCameraTransforms.TransformType, Matrix4f> enumMap = new EnumMap<ItemCameraTransforms.TransformType, Matrix4f>(Transforms.blockTransforms);
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            Matrix4f matrix4f = Transforms.itemTransforms.get(type);
            if (matrix4f == null) continue;
            enumMap.put(type, matrix4f);
        }
        return new PassthruModelItem((IXUItem)this, () -> new PassthruModelItem.ModelLayer(enumMap){

            @Override
            public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
                if (ItemLuxSaber.this.bladeOnly.get().booleanValue()) {
                    if (metadata == LuxColors.BLACK.ordinal()) {
                        GlStateManager.func_179090_x();
                        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    } else {
                        GlStateManager.func_179140_f();
                        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    }
                }
                return super.handlePerspective(cameraTransformType);
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postTextureRegister() {
        this.blank = Textures.getSprite("blank");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseTexture() {
        return this.blank;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsTool() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clearCaches() {
        this.blank = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean allowOverride() {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        if (!EnchantmentDurability.func_92097_a((ItemStack)stack, (int)i, (Random)target.func_70681_au())) {
            XUItemEnergyStorage capability = (XUItemEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (capability == null) {
                throw new IllegalStateException();
            }
            capability.setEnergyStored(Math.max(0, capability.getEnergyStored() - 200));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IEnergyStorage storage = (IEnergyStorage)Validate.notNull((Object)stack.getCapability(CapabilityEnergy.ENERGY, null));
        tooltip.add(String.format("%s RF / %s RF", StringHelper.format(storage.getEnergyStored()), StringHelper.format(storage.getMaxEnergyStored())));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new XUItemEnergyStorage(stack, 40000, 200, 0);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        IEnergyStorage capability = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (slot != EntityEquipmentSlot.MAINHAND) {
            return HashMultimap.create();
        }
        Object itemAttributeModifiers = capability == null || capability.getEnergyStored() <= 0 ? HashMultimap.create() : this.func_111205_h(slot);
        itemAttributeModifiers.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(UUID, "Long Swipe", 3.0, 0));
        return itemAttributeModifiers;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addQuads(PassthruModelItem.ModelLayer model, ItemStack stack, World world, EntityLivingBase entity) {
        float v;
        float[] saberHiltBottom = new float[]{12.0f, 13.5f, 14.0f, 15.5f};
        float[] saberHiltTop = new float[]{14.0f, 13.5f, 16.0f, 15.5f};
        float[] saberHiltA = new float[]{12.0f, 3.5f, 14.0f, 7.5f};
        float[] saberHiltB = new float[]{12.5f, 1.5f, 14.0f, 3.5f};
        float[] saberHiltC = new float[]{12.0f, 0.0f, 14.0f, 1.5f};
        float[] saberHiltC2 = new float[]{12.0f, 0.5f, 14.0f, 1.5f};
        boolean renderBladeOnly = this.bladeOnly.get();
        if (!renderBladeOnly) {
            model.clear();
            BoxModel standard = new BoxModel();
            standard.addBox(0.375f, 0.0f, 0.375f, 0.625f, 0.5f, 0.625f).setTextureBounds(new float[][]{saberHiltBottom, saberHiltTop, saberHiltA, saberHiltA, saberHiltA, saberHiltA});
            standard.addBox(0.40625f, 0.5f, 0.40625f, 0.59375f, 0.75f, 0.59375f).setTextureBounds(new float[][]{saberHiltBottom, saberHiltTop, saberHiltB, saberHiltB, saberHiltB, saberHiltB}).setInvisible(3);
            standard.addBox(0.375f, 0.75f, 0.375f, 0.625f, 0.9375f, 0.625f).setTextureBounds(new float[][]{saberHiltBottom, saberHiltTop, saberHiltC, saberHiltC, saberHiltC, saberHiltC});
            standard.setTexture("luxsaber");
            model.addBoxModel(standard);
        }
        if ((v = MathHelper.func_76131_a((float)this.stackMap.getOrDefault(stack, Float.valueOf(0.0f)).floatValue(), (float)0.0f, (float)1.0f)) > 0.0f) {
            ItemCameraTransforms.TransformType[] transformTypes;
            ItemCameraTransforms.TransformType[] transformTypeArray;
            v = Math.min(1.0f, v + MCTimer.renderPartialTickTime * 0.05f);
            int color = stack.func_77960_j();
            float[] saberGlowSide = new float[]{((float)(color * 4) + 0.0f) / 2.0f, 15.5f, ((float)(color * 4) + 4.0f) / 2.0f, 16.0f};
            float[] saberGlowTop = new float[]{((float)(color * 4) + 0.0f) / 2.0f, 13.5f, ((float)(color * 4) + 4.0f) / 2.0f, 15.5f};
            float[] saberSide = new float[]{((float)(color * 3) + 0.0f) / 2.0f, (1.0f - v) * 24.0f / 2.0f, ((float)(color * 3) + 3.0f) / 2.0f, 12.0f};
            float[] saberTop = new float[]{((float)(color * 3) + 0.0f) / 2.0f, 12.0f, ((float)(color * 3) + 3.0f) / 2.0f, 13.5f};
            BoxModel litSaber = new BoxModel();
            if (!renderBladeOnly) {
                litSaber.addBox(0.375f, 0.0f, 0.375f, 0.625f, 0.5f, 0.625f).setTextureBounds(new float[][]{saberHiltBottom, saberHiltTop, saberHiltA, saberHiltA, saberHiltA, saberHiltA});
                litSaber.addBox(0.40625f, 0.5f, 0.40625f, 0.59375f, 0.75f, 0.59375f).setTextureBounds(new float[][]{saberHiltBottom, saberHiltTop, saberHiltB, saberHiltB, saberHiltB, saberHiltB}).setInvisible(3);
                litSaber.addBox(0.375f, 0.75f, 0.375f, 0.625f, 0.875f, 0.625f).setTextureBounds(new float[][]{saberHiltBottom, saberHiltTop, saberHiltC2, saberHiltC2, saberHiltC2, saberHiltC2}).setInvisible(2);
                litSaber.addBox(0.375f, 0.875f, 0.375f, 0.625f, 0.9375f, 0.625f).setTextureBounds(new float[][]{saberGlowTop, saberGlowTop, saberGlowSide, saberGlowSide, saberGlowSide, saberGlowSide}).setInvisible(2);
            }
            float v2 = Math.min(v * 1.2f, 1.0f) * 0.5f;
            float v1 = 3.0f;
            litSaber.addBox(0.5f - v2 * 1.5f / 16.0f, 0.9375f, 0.5f - v2 * 1.5f / 16.0f, 0.5f + v2 * 1.5f / 16.0f, 0.9375f + v * v1, 0.5f + v2 * 1.5f / 16.0f).setTextureBounds(new float[][]{saberTop, saberTop, saberSide, saberSide, saberSide, saberSide}).setInvisible(1);
            v2 = Math.min(v * 1.2f, 1.0f);
            litSaber.addBox(0.5f - v2 * 1.5f / 16.0f, 0.9375f, 0.5f - v2 * 1.5f / 16.0f, 0.5f + v2 * 1.5f / 16.0f, 0.9375f + v * (v1 + 0.1f), 0.5f + v2 * 1.5f / 16.0f).setTextureBounds(new float[][]{saberTop, saberTop, saberSide, saberSide, saberSide, saberSide}).setInvisible(1);
            litSaber.setTexture("luxsaber");
            if (renderBladeOnly) {
                ItemCameraTransforms.TransformType[] transformTypeArray2 = new ItemCameraTransforms.TransformType[4];
                transformTypeArray2[0] = ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
                transformTypeArray2[1] = ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
                transformTypeArray2[2] = ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
                transformTypeArray = transformTypeArray2;
                transformTypeArray2[3] = ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            } else {
                ItemCameraTransforms.TransformType[] transformTypeArray3 = new ItemCameraTransforms.TransformType[2];
                transformTypeArray3[0] = ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
                transformTypeArray = transformTypeArray3;
                transformTypeArray3[1] = ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            for (ItemCameraTransforms.TransformType type : transformTypes = transformTypeArray) {
                Pair pair = (Pair)model.transformMap.get(type);
                IBakedModel key = (IBakedModel)pair.getKey();
                if (key != model) continue;
                MutableModel mutableModel = new MutableModel(Transforms.itemToolsTransforms);
                model.transformMap.put(type, Pair.of((Object)mutableModel, (Object)pair.getRight()));
            }
            for (ItemCameraTransforms.TransformType type : transformTypes) {
                MutableModel key = (MutableModel)((Pair)model.transformMap.get(type)).getKey();
                key.clear();
                for (Box box : litSaber) {
                    for (EnumFacing facing : FacingHelper.facingPlusNull) {
                        List<BakedQuad> quads = box.getQuads(facing);
                        if (quads == null) continue;
                        key.generalQuads.addAll(quads);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMaxMetadata() {
        return LuxColors.values().length - 1;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void overrideRendering(RenderSpecificHandEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() == this) {
            Minecraft.func_71410_x().func_175597_ag().func_187457_a((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress());
            GLStateAttributes states = GLStateAttributes.loadStates();
            this.bladeOnly.set(true);
            Minecraft.func_71410_x().func_175597_ag().func_187457_a((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress());
            this.bladeOnly.set(false);
            states.restore();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void run(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        HashMap prevMap = Maps.newHashMap(this.stackMap);
        this.stackMap.clear();
        WorldClient world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        for (EntityPlayer player : world.func_175644_a(EntityPlayer.class, s -> true)) {
            for (ItemStack stack : player.func_184214_aD()) {
                double durabilityForDisplay;
                if (stack.func_77973_b() != this || (durabilityForDisplay = 1.0 - this.getDurabilityForDisplay(stack)) == 0.0) continue;
                this.stackMap.put(stack, Float.valueOf(Math.min(prevMap.getOrDefault(stack, Float.valueOf(0.0f)).floatValue() + 0.05f, 1.0f)));
            }
        }
    }

    public static class XUItemEnergyStorage
    implements IEnergyStorage,
    ICapabilityProvider {
        protected final ItemStack stack;
        protected int capacity;
        protected int maxReceive;
        protected int maxExtract;

        public XUItemEnergyStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
            this.stack = stack;
            this.capacity = capacity;
            this.maxReceive = maxReceive;
            this.maxExtract = maxExtract;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyReceived = Math.min(this.capacity - this.getEnergyStored(), Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() + energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, maxExtract));
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() - energyExtracted);
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            NBTTagCompound tagCompound = this.stack.func_77978_p();
            return tagCompound == null ? 0 : tagCompound.func_74762_e("Energy");
        }

        private void setEnergyStored(int energy) {
            this.stack.func_77983_a("Energy", (NBTBase)new NBTTagInt(energy));
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return this.maxExtract > 0;
        }

        public boolean canReceive() {
            return this.maxReceive > 0;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this) : null);
        }
    }
}

