/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.IWidgetClientNetwork;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetScrollBar;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WidgetScrollBarServer
extends WidgetScrollBar
implements IWidgetServerNetwork,
IWidgetClientNetwork {
    int updateLevel;
    private int minValue;
    private int maxValue;

    public WidgetScrollBarServer(int x, int y, int h, int minValue, int maxValue) {
        super(x, y, h, minValue, maxValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    protected void onChange() {
        ++this.updateLevel;
        XUPacketBuffer packetBuffer = new XUPacketBuffer();
        packetBuffer.writeInt(this.scrollValue);
        this.container.sendInputPacket(this, packetBuffer);
    }

    public abstract int getValueServer();

    public abstract void setValueServer(int var1);

    @Override
    public void receiveClientPacket(XUPacketBuffer buffer) {
        int newLevel = MathHelper.func_76125_a((int)buffer.readInt(), (int)this.minValue, (int)this.maxValue);
        if (newLevel != this.getValueServer()) {
            ++this.updateLevel;
            this.setValueServer(newLevel);
        }
    }

    @Override
    public void addToDescription(XUPacketBuffer packet) {
        packet.writeInt(this.getValueServer());
        packet.writeInt(this.updateLevel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        int newLevel = packet.readInt();
        int newUpdateLevel = packet.readInt();
        if (newUpdateLevel >= this.updateLevel) {
            this.setValue(newLevel);
        }
    }
}

