/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.RunnableClient;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.jei.ParticlePing;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketClientToServer;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.utils.CapGetter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class Radar {
    @SideOnly(value=Side.CLIENT)
    static ItemStack lastRenderedStack = StackHelper.empty();

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new Radar());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTooltip(RenderTooltipEvent.Pre event) {
        lastRenderedStack = event.getStack();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderFinish(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            lastRenderedStack = StackHelper.empty();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private ItemStack getStackUnderMouse() {
        ItemStack stack;
        GuiContainer guiContainer;
        Slot slotUnderMouse;
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiContainer && (slotUnderMouse = (guiContainer = (GuiContainer)guiScreen).getSlotUnderMouse()) != null && StackHelper.isNonNull(stack = slotUnderMouse.func_75211_c())) {
            return stack;
        }
        return lastRenderedStack;
    }

    @NetworkHandler.XUPacket
    public static class PacketPong
    extends XUPacketServerToClient {
        public static final int MAX_SIZE = 30;
        ArrayList<BlockPos> positions;

        public PacketPong() {
        }

        public PacketPong(ArrayList<BlockPos> positions) {
            this.positions = positions;
        }

        @Override
        public void writeData() throws Exception {
            this.writeInt(this.positions.size());
            for (BlockPos position : this.positions) {
                this.writeBlockPos(position);
            }
        }

        @Override
        public void readData(EntityPlayer player) {
            int size = this.readInt();
            this.positions = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.positions.add(this.readBlockPos());
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            return new RunnableClient(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    Minecraft.func_71410_x().field_71439_g.func_71053_j();
                    for (BlockPos position : positions) {
                        for (int i = 0; i < 20; ++i) {
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticlePing(Minecraft.func_71410_x().field_71441_e, position));
                        }
                    }
                }
            };
        }
    }

    @NetworkHandler.XUPacket
    public static class PacketPing
    extends XUPacketClientToServer {
        static final long TIMEOUT = 10L;
        static final int RANGE = 16;
        static WeakHashMap<EntityPlayer, Long> timeOutsHandler = new WeakHashMap();
        ItemStack stack;
        private EntityPlayer player;

        public PacketPing() {
        }

        public PacketPing(@Nonnull ItemStack stack) {
            this.stack = stack.func_77946_l();
            this.stack.func_77982_d(null);
        }

        @Override
        public void writeData() throws Exception {
            this.writeItemStack(this.stack);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.player = player;
            this.stack = this.readItemStack();
        }

        @Override
        public Runnable doStuffServer() {
            return () -> {
                if (this.player == null || StackHelper.isNull(this.stack) || this.stack.func_77973_b() == StackHelper.nullItem()) {
                    return;
                }
                World world = this.player.field_70170_p;
                long time = world.func_82737_E();
                Long aLong = timeOutsHandler.get(this.player);
                if (aLong != null && time - aLong < 10L) {
                    return;
                }
                timeOutsHandler.put(this.player, time);
                int x = (int)Math.round(this.player.field_70165_t);
                int y = (int)Math.round(this.player.field_70163_u);
                int z = (int)Math.round(this.player.field_70161_v);
                Item trueItem = this.stack.func_77973_b();
                int trueItemDamage = this.stack.func_77952_i();
                TreeSet<BlockPos> positions = new TreeSet<BlockPos>(Comparator.comparingDouble(o -> this.getRange(x, y, z, (BlockPos)o)));
                for (int cx = x - 16; cx <= x + 16; cx += 16) {
                    for (int cz = z - 16; cz <= z + 16; cz += 16) {
                        BlockPos p = new BlockPos(cx, y, cz);
                        if (!world.func_175667_e(p)) continue;
                        Chunk chunk = world.func_175726_f(p);
                        Set entrySet = chunk.func_177434_r().entrySet();
                        for (Map.Entry entry2 : entrySet) {
                            TileEntity tile;
                            IItemHandler handler;
                            if (!this.inRange(x, y, z, (BlockPos)entry2.getKey()) || (handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)(tile = (TileEntity)entry2.getValue()), null)) == null) continue;
                            for (int i = 0; i < handler.getSlots(); ++i) {
                                ItemStack stack1 = handler.getStackInSlot(i);
                                if (StackHelper.isNull(stack1) || stack1.func_77973_b() != trueItem || trueItem.func_77614_k() && stack1.func_77952_i() != trueItemDamage) continue;
                                positions.add((BlockPos)entry2.getKey());
                                if (positions.size() < 30) continue;
                                positions.pollLast();
                            }
                        }
                    }
                }
                if (!positions.isEmpty()) {
                    NetworkHandler.sendPacketToPlayer(new PacketPong(new ArrayList<BlockPos>(positions)), this.player);
                }
            };
        }

        public int getRange(int x, int y, int z, BlockPos pos) {
            return Math.abs(pos.func_177958_n() - x) + Math.abs(pos.func_177956_o() - y) + Math.abs(pos.func_177952_p() - z);
        }

        public boolean inRange(int x, int y, int z, BlockPos pos) {
            return Math.abs(pos.func_177958_n() - x) <= 16 && Math.abs(pos.func_177956_o() - y) <= 16 && Math.abs(pos.func_177952_p() - z) <= 16;
        }
    }
}

