/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.Materials;
import mekanism.tools.item.ItemMekanismHoe;
import mekanism.tools.item.ItemMekanismPaxel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum ToolsItem {
    WOOD_PAXEL("WoodPaxel", new ItemMekanismPaxel(Item.ToolMaterial.WOOD)),
    STONE_PAXEL("StonePaxel", new ItemMekanismPaxel(Item.ToolMaterial.STONE)),
    IRON_PAXEL("IronPaxel", new ItemMekanismPaxel(Item.ToolMaterial.IRON)),
    DIAMOND_PAXEL("DiamondPaxel", new ItemMekanismPaxel(Item.ToolMaterial.DIAMOND)),
    OBSIDIAN_HOE("ObsidianHoe", new ItemMekanismHoe(Materials.OBSIDIAN)),
    OBSIDIAN_PAXEL("ObsidianPaxel", new ItemMekanismPaxel(Materials.OBSIDIAN));

    public static final List<ToolsItem> BRONZE_SET;
    public static final List<ToolsItem> OSMIUM_SET;
    public static final List<ToolsItem> OBSIDIAN_SET;
    public static final List<ToolsItem> GLOWSTONE_SET;
    public static final List<ToolsItem> STEEL_SET;
    public static final List<ToolsItem> LAPIS_LAZULI_SET;
    @Nonnull
    private Item item;

    private <ITEM extends Item> ToolsItem(String name, ITEM item) {
        this.item = ((Item)item.func_77655_b(name).setRegistryName(new ResourceLocation("mekanismtools", name))).func_77637_a((CreativeTabs)Mekanism.tabMekanism);
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    private void updateItem(Item item) {
        this.item = item;
    }

    @Nonnull
    public ItemStack getRepairStack() {
        return this.item instanceof IHasRepairType ? ((IHasRepairType)this.item).getRepairStack() : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    @Nonnull
    public ItemStack getItemStack(int size) {
        return new ItemStack(this.getItem(), size);
    }

    @Nonnull
    public ItemStack getItemStackAnyDamage() {
        return this.getItemStackAnyDamage(1);
    }

    @Nonnull
    public ItemStack getItemStackAnyDamage(int size) {
        return new ItemStack(this.getItem(), size, Short.MAX_VALUE);
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        for (ToolsItem toolsItem : ToolsItem.values()) {
            registry.register((IForgeRegistryEntry)toolsItem.getItem());
        }
    }

    public static void remapItems() {
        for (ToolsItem toolsItem : ToolsItem.values()) {
            ResourceLocation registryName = toolsItem.getItem().getRegistryName();
            toolsItem.updateItem((Item)ForgeRegistries.ITEMS.getValue(registryName));
        }
    }

    static {
        BRONZE_SET = Arrays.asList(new ToolsItem[0]);
        OSMIUM_SET = Arrays.asList(new ToolsItem[0]);
        OBSIDIAN_SET = Arrays.asList(OBSIDIAN_HOE, OBSIDIAN_PAXEL);
        GLOWSTONE_SET = Arrays.asList(new ToolsItem[0]);
        STEEL_SET = Arrays.asList(new ToolsItem[0]);
        LAPIS_LAZULI_SET = Arrays.asList(new ToolsItem[0]);
    }
}

