/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import crazypants.enderio.base.conduit.facade.ItemConduitFacade;
import de.lathanael.facadepainter.network.SyncedConfig;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ToggleableShapelessRecipe
extends ShapelessOreRecipe {
    public ToggleableShapelessRecipe(ResourceLocation group, NonNullList<Ingredient> input, ItemStack result) {
        super(group, input, result);
    }

    public boolean func_77569_a(InventoryCrafting inventory, World worldIn) {
        int ingredientCount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            ++ingredientCount;
            if (SyncedConfig.enableShapelessClearingRecipe || !(itemstack.func_77973_b() instanceof ItemConduitFacade)) continue;
            return false;
        }
        if (!SyncedConfig.enableChamaeleoPaint && ingredientCount > 3) {
            return false;
        }
        return super.func_77569_a(inventory, worldIn);
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof ItemConduitFacade)) continue;
            return new ItemStack(itemstack.func_77973_b(), 1, itemstack.func_77952_i());
        }
        return super.func_77572_b(inventory);
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for toggleable shapeless recipe");
            }
            return new ToggleableShapelessRecipe(group.isEmpty() ? new ResourceLocation("facadepainter") : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, result);
        }
    }
}

