/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import crazypants.enderio.base.conduit.facade.ItemConduitFacade;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import de.lathanael.facadepainter.init.ItemRegistry;
import de.lathanael.facadepainter.network.SyncedConfig;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PaintedFacadeRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ResourceLocation group;
    private final ItemStack output;
    public final NonNullList<Ingredient> input;

    public PaintedFacadeRecipe(@Nullable ResourceLocation group, NonNullList<Ingredient> input, ItemStack output) {
        this.group = group != null ? group : new ResourceLocation("facadepainter");
        this.input = input;
        this.output = output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting inventory, World worldIn) {
        int ingredientCount = 0;
        ItemStack facade = null;
        ItemStack paintSource = null;
        ItemStack chamaeleo = null;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            ++ingredientCount;
            if (itemstack.func_77973_b() instanceof ItemConduitFacade) {
                facade = itemstack;
                continue;
            }
            if (itemstack.func_77973_b() == ItemRegistry.itemChamaeleoPaint) {
                chamaeleo = itemstack;
                continue;
            }
            paintSource = itemstack;
        }
        if (ingredientCount < 2) {
            return false;
        }
        if (ingredientCount > 3) {
            return false;
        }
        if (ingredientCount < 3 && SyncedConfig.useChamaeleoPaint) {
            return false;
        }
        if (ingredientCount > 2 && !SyncedConfig.useChamaeleoPaint) {
            return false;
        }
        if (facade == null || paintSource == null) {
            return false;
        }
        if (SyncedConfig.useChamaeleoPaint && chamaeleo == null) {
            return false;
        }
        Map painterRecipes = MachineRecipeRegistry.instance.getRecipesForMachine("painter");
        for (IMachineRecipe rec : painterRecipes.values()) {
            AbstractPainterTemplate temp;
            if (!(rec instanceof AbstractPainterTemplate) || !(temp = (AbstractPainterTemplate)rec).isPartialRecipe(paintSource, facade)) continue;
            return true;
        }
        return false;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventory) {
        NonNullList returnStack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < returnStack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b() || itemstack.func_77973_b() instanceof ItemConduitFacade || itemstack.func_77973_b() == ItemRegistry.itemChamaeleoPaint) continue;
            if (itemstack.func_190916_E() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(1);
                returnStack.set(i, (Object)itemstack);
                continue;
            }
            returnStack.set(i, (Object)itemstack.func_77946_l());
        }
        return returnStack;
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        ItemStack facade = null;
        ItemStack paintSource = null;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b() instanceof ItemConduitFacade) {
                facade = itemstack.func_77946_l();
                continue;
            }
            if (itemstack.func_77973_b() == ItemRegistry.itemChamaeleoPaint) continue;
            paintSource = itemstack;
        }
        Block paintBlock = PaintUtil.getBlockFromItem(paintSource);
        if (paintBlock == null) {
            return ItemStack.field_190927_a;
        }
        IBlockState paintState = PaintUtil.Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(paintSource, (Block)paintBlock);
        if (paintState == null) {
            return ItemStack.field_190927_a;
        }
        facade.func_190920_e(1);
        PaintUtil.setPaintSource((ItemStack)facade, (ItemStack)paintSource);
        PaintUtil.setSourceBlock((ItemStack)facade, (IBlockState)paintState);
        return facade;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public String func_193358_e() {
        return this.group.toString();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public boolean func_194133_a(int width, int height) {
        if (SyncedConfig.useChamaeleoPaint) {
            return width * height > 2;
        }
        return width * height > 1;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            NonNullList ingredients = NonNullList.func_191196_a();
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)JsonUtils.func_152754_s((JsonObject)json, (String)"facade"), (JsonContext)context));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for facade painting recipe");
            }
            return new PaintedFacadeRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, result);
        }
    }
}

