/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.integration.jei;

import crazypants.enderio.base.conduit.facade.ItemConduitFacade;
import de.lathanael.facadepainter.init.ItemRegistry;
import de.lathanael.facadepainter.integration.jei.FacadeClearingRecipeWrapper;
import de.lathanael.facadepainter.integration.jei.JEIFacadePainterPlugin;
import de.lathanael.facadepainter.network.SyncedConfig;
import de.lathanael.facadepainter.recipes.ToggleableShapelessRecipe;
import java.util.Arrays;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JEIBlacklistUpdater {
    private boolean isFacadeClearingRecipeEnabled;
    private boolean isFacadePaintingCategoryHidden;
    private boolean isChamaeleoPaintEnabled = SyncedConfig.enableChamaeleoPaint;

    public JEIBlacklistUpdater() {
        this.isFacadePaintingCategoryHidden = SyncedConfig.hideJEIFacadePaintingRecipeCategory;
        this.isFacadeClearingRecipeEnabled = SyncedConfig.enableShapelessClearingRecipe;
    }

    public void handleBlacklisting() {
        if (JEIFacadePainterPlugin.instance != null && JEIFacadePainterPlugin.instance.getJEIRuntime() != null) {
            boolean status = SyncedConfig.enableChamaeleoPaint;
            if (status != this.isChamaeleoPaintEnabled) {
                this.handleChamaeleoPaintRecipe(status);
                this.isChamaeleoPaintEnabled = status;
            }
            if ((status = SyncedConfig.hideJEIFacadePaintingRecipeCategory) != this.isFacadePaintingCategoryHidden) {
                this.handleFacadePaintingCategory(status);
                this.isFacadePaintingCategoryHidden = status;
            }
            if ((status = SyncedConfig.enableShapelessClearingRecipe) != this.isFacadeClearingRecipeEnabled) {
                this.handleFacadeClearingRecipe(status);
                this.isFacadePaintingCategoryHidden = status;
            }
        }
    }

    private void handleFacadePaintingCategory(boolean hide) {
        if (hide) {
            JEIFacadePainterPlugin.instance.getJEIRuntime().getRecipeRegistry().hideRecipeCategory("facadepainter.crafting");
        } else {
            JEIFacadePainterPlugin.instance.getJEIRuntime().getRecipeRegistry().unhideRecipeCategory("facadepainter.crafting");
        }
    }

    private void handleChamaeleoPaintRecipe(boolean hide) {
        IRecipeRegistry registry = JEIFacadePainterPlugin.instance.getJEIRuntime().getRecipeRegistry();
        if (!hide) {
            JEIFacadePainterPlugin.instance.getJEIModRegistry().getIngredientRegistry().removeIngredientsAtRuntime(VanillaTypes.ITEM, Arrays.asList(new ItemStack((Item)ItemRegistry.itemChamaeleoPaint)));
            for (Object recipe : JEIFacadePainterPlugin.instance.getToggleableShapelessRecipes()) {
                if (!(recipe instanceof ToggleableShapelessRecipe) || ((ToggleableShapelessRecipe)((Object)recipe)).func_77571_b().func_77973_b() instanceof ItemConduitFacade) continue;
                registry.hideRecipe(registry.getRecipeWrapper((Object)((ToggleableShapelessRecipe)((Object)recipe)), "minecraft.crafting"), "minecraft.crafting");
            }
        } else {
            JEIFacadePainterPlugin.instance.getJEIModRegistry().getIngredientRegistry().addIngredientsAtRuntime(VanillaTypes.ITEM, Arrays.asList(new ItemStack((Item)ItemRegistry.itemChamaeleoPaint)));
            for (Object recipe : JEIFacadePainterPlugin.instance.getToggleableShapelessRecipes()) {
                if (!(recipe instanceof ToggleableShapelessRecipe) || ((ToggleableShapelessRecipe)((Object)recipe)).func_77571_b().func_77973_b() instanceof ItemConduitFacade) continue;
                registry.unhideRecipe(registry.getRecipeWrapper((Object)((ToggleableShapelessRecipe)((Object)recipe)), "minecraft.crafting"), "minecraft.crafting");
            }
        }
    }

    private void handleFacadeClearingRecipe(boolean hide) {
        IRecipeRegistry registry = JEIFacadePainterPlugin.instance.getJEIRuntime().getRecipeRegistry();
        if (!hide) {
            for (Object recipeWrapper : JEIFacadePainterPlugin.instance.getToggleableShapelessRecipes()) {
                if (!(recipeWrapper instanceof FacadeClearingRecipeWrapper)) continue;
                registry.hideRecipe((IRecipeWrapper)((FacadeClearingRecipeWrapper)recipeWrapper), "minecraft.crafting");
            }
        } else {
            for (Object recipeWrapper : JEIFacadePainterPlugin.instance.getToggleableShapelessRecipes()) {
                if (!(recipeWrapper instanceof FacadeClearingRecipeWrapper)) continue;
                registry.unhideRecipe((IRecipeWrapper)((FacadeClearingRecipeWrapper)recipeWrapper), "minecraft.crafting");
            }
        }
    }
}

