/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.integration.jei;

import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.base.conduit.facade.ItemConduitFacade;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import de.lathanael.facadepainter.FacadePainter;
import de.lathanael.facadepainter.init.ItemRegistry;
import de.lathanael.facadepainter.integration.jei.FacadeClearingRecipe;
import de.lathanael.facadepainter.integration.jei.FacadePaintingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FacadePainterRecipeLists {
    @Nonnull
    private final List<FacadePaintingRecipe> VALID_RECIPES = new ArrayList<FacadePaintingRecipe>();
    @Nonnull
    private final List<List<ItemStack>> FACADE_RESULTS = new ArrayList<List<ItemStack>>();
    @Nonnull
    private final ItemStack FACADE = new ItemStack(ModObject.itemConduitFacade.getItem(), 1);
    @Nonnull
    private final ItemStack TRANSPARENT_FACADE = new ItemStack(ModObject.itemConduitFacade.getItem(), 1, 2);
    @Nonnull
    private final ItemStack HARDENED_FACADE = new ItemStack(ModObject.itemConduitFacade.getItem(), 1, 1);
    @Nonnull
    private final ItemStack TRANSPARENT_HARDENED_FACADE = new ItemStack(ModObject.itemConduitFacade.getItem(), 1, 3);
    @Nonnull
    private final ItemStack CHAMAELEO_PAINT = new ItemStack((Item)ItemRegistry.itemChamaeleoPaint, 1);

    public FacadePainterRecipeLists(IModRegistry registry) {
        this.generate(registry);
    }

    private void generate(IModRegistry registry) {
        Iterator listIterator = registry.getIngredientRegistry().getAllIngredients(VanillaTypes.ITEM).iterator();
        ArrayList<ItemStack> facadeResults = new ArrayList<ItemStack>();
        ArrayList<ItemStack> transparentFacadeResults = new ArrayList<ItemStack>();
        ArrayList<ItemStack> hardenedFacadeResults = new ArrayList<ItemStack>();
        ArrayList<ItemStack> transparentHardenedFacadeResults = new ArrayList<ItemStack>();
        while (listIterator.hasNext()) {
            Block tempBlock;
            FluidStack tempFluid;
            ItemStack tempStack = (ItemStack)listIterator.next();
            if (tempStack.func_190926_b() || tempStack.func_77973_b() instanceof ItemConduitFacade || (tempFluid = FluidUtil.getFluidTypeFromItem((ItemStack)tempStack)) != null && tempFluid.getFluid() != null || (tempBlock = PaintUtil.getBlockFromItem((ItemStack)tempStack)) != null && tempBlock instanceof IPaintable || tempBlock == Blocks.field_150350_a || tempStack.func_77973_b() == Items.field_190931_a) continue;
            Map painterRecipes = MachineRecipeRegistry.instance.getRecipesForMachine("painter");
            boolean isRecipe = false;
            for (IMachineRecipe rec : painterRecipes.values()) {
                if (!(rec instanceof AbstractPainterTemplate)) continue;
                AbstractPainterTemplate recipe = (AbstractPainterTemplate)rec;
                try {
                    isRecipe = recipe.isRecipe(tempStack, this.FACADE);
                }
                catch (Exception ex) {
                    isRecipe = false;
                }
                if (isRecipe) {
                    try {
                        this.VALID_RECIPES.add(new FacadePaintingRecipe(recipe.getCompletedResult(tempStack, this.FACADE), Arrays.asList(tempStack, this.FACADE, this.CHAMAELEO_PAINT)));
                        facadeResults.add(recipe.getCompletedResult(tempStack, this.FACADE));
                    }
                    catch (Exception ex) {
                        FacadePainter.logger.debug("Empty ingredients list supplied for: " + tempStack.toString());
                    }
                }
                try {
                    isRecipe = recipe.isRecipe(tempStack, this.HARDENED_FACADE);
                }
                catch (Exception ex) {
                    isRecipe = false;
                }
                if (isRecipe) {
                    hardenedFacadeResults.add(recipe.getCompletedResult(tempStack, this.HARDENED_FACADE));
                }
                try {
                    isRecipe = recipe.isRecipe(tempStack, this.TRANSPARENT_FACADE);
                }
                catch (Exception ex) {
                    isRecipe = false;
                }
                if (isRecipe) {
                    transparentFacadeResults.add(recipe.getCompletedResult(tempStack, this.TRANSPARENT_FACADE));
                }
                try {
                    isRecipe = recipe.isRecipe(tempStack, this.TRANSPARENT_HARDENED_FACADE);
                }
                catch (Exception ex) {
                    isRecipe = false;
                }
                if (!isRecipe) continue;
                transparentHardenedFacadeResults.add(recipe.getCompletedResult(tempStack, this.TRANSPARENT_HARDENED_FACADE));
            }
            this.FACADE_RESULTS.add(facadeResults);
            this.FACADE_RESULTS.add(hardenedFacadeResults);
            this.FACADE_RESULTS.add(transparentFacadeResults);
            this.FACADE_RESULTS.add(transparentHardenedFacadeResults);
        }
    }

    public List<FacadePaintingRecipe> getRecipeList() {
        return this.VALID_RECIPES;
    }

    public List<List<ItemStack>> getClearingRecipeList() {
        return this.FACADE_RESULTS;
    }

    public List<FacadeClearingRecipe> getPseudoClearingRecipeList() {
        ArrayList<FacadeClearingRecipe> pseudoClearingList = new ArrayList<FacadeClearingRecipe>();
        pseudoClearingList.add(new FacadeClearingRecipe(this.FACADE, Arrays.asList(this.FACADE)));
        pseudoClearingList.add(new FacadeClearingRecipe(this.HARDENED_FACADE, Arrays.asList(this.HARDENED_FACADE)));
        pseudoClearingList.add(new FacadeClearingRecipe(this.TRANSPARENT_FACADE, Arrays.asList(this.TRANSPARENT_FACADE)));
        pseudoClearingList.add(new FacadeClearingRecipe(this.TRANSPARENT_HARDENED_FACADE, Arrays.asList(this.TRANSPARENT_HARDENED_FACADE)));
        return pseudoClearingList;
    }
}

