/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.config;

import de.lathanael.facadepainter.FacadePainter;
import de.lathanael.facadepainter.integration.ModIntegration;
import de.lathanael.facadepainter.network.NetworkHandler;
import de.lathanael.facadepainter.network.PacketConfigSync;
import de.lathanael.facadepainter.network.SyncedConfig;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Config(modid="facadepainter")
public class Configs {
    public static FeatureConfigs features = new FeatureConfigs();
    public static RecipeConfigs recipes = new RecipeConfigs();

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("facadepainter")) {
                ConfigManager.sync((String)"facadepainter", (Config.Type)Config.Type.INSTANCE);
                SyncedConfig.updateValuesSP();
                ModIntegration.updateJEIRecipeList();
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player.field_70170_p.field_72995_K) {
                return;
            }
            FacadePainter.logger.info("Sending server configs to client: " + event.player.func_70005_c_());
            PacketConfigSync message = new PacketConfigSync();
            message.enableChamaeleoPaint = Configs.features.enableChamaeleoPaint;
            message.hideJEIFacadePaintingRecipeCategory = Configs.features.hideJEIFacadePaintingRecipeCategory;
            message.useChamaeleoPaint = Configs.recipes.useChamaeleoPaint;
            message.enableShapelessClearingRecipe = Configs.recipes.enableShapelessClearingRecipe;
            NetworkHandler.sendToClient(message, (EntityPlayerMP)event.player);
        }
    }

    public static class RecipeConfigs {
        @Config.Comment(value={"Enable the usage of Chamaeleo Paint in the facade recipe. [default=false]", "", "If enabled and the Chamaeleo Paint item is disabled the facade painting recipe will", "become uncraftable without user added recipes for the Chamaeleo Paint item!"})
        public boolean useChamaeleoPaint = false;
        @Config.Comment(value={"If set to false the shapeless recipe to clear a painted facade by putting it into", "any valid crafting grid is removed. [default=true]"})
        public boolean enableShapelessClearingRecipe = true;
    }

    public static class FeatureConfigs {
        @Config.Comment(value={"Enable the Chamaeleo Paint item. [default=false]"})
        public boolean enableChamaeleoPaint = false;
        @Config.Comment(value={"Set to true to hide the 'Facade Painting' catergory in JEI. [default=false]"})
        public boolean hideJEIFacadePaintingRecipeCategory = false;
    }
}

