/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.monitor;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.machine.base.block.AbstractMachineBlock;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.powertools.machine.monitor.ContainerPowerMonitor;
import crazypants.enderio.powertools.machine.monitor.GuiPowerMonitor;
import crazypants.enderio.powertools.machine.monitor.TESRPowerMonitor;
import crazypants.enderio.powertools.machine.monitor.TilePowerMonitor;
import crazypants.enderio.util.FuncUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPowerMonitor
extends AbstractMachineBlock<TilePowerMonitor>
implements IAdvancedTooltipProvider,
IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint,
IHaveTESR {
    private final boolean advanced;

    public static BlockPowerMonitor createAdvancedPowerMonitor(@Nonnull IModObject modObject) {
        BlockPowerMonitor result = new BlockPowerMonitor(modObject, true);
        result.init();
        return result;
    }

    public static Block createPowerMonitor(@Nonnull IModObject modObject) {
        BlockPowerMonitor result = new BlockPowerMonitor(modObject, false);
        result.init();
        return result;
    }

    public BlockPowerMonitor(@Nonnull IModObject mo, boolean advanced) {
        super(mo);
        this.advanced = advanced;
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    public void init() {
        super.init();
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TilePowerMonitor te) {
        return new ContainerPowerMonitor(player.field_71071_by, te);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TilePowerMonitor te) {
        return new GuiPowerMonitor(player.field_71071_by, te);
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (ItemStack)itemstack);
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TilePowerMonitor tileEntity) {
        blockStateWrapper.addCacheKey((Object)tileEntity.getFacing());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
    }

    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull TilePowerMonitor te) {
        super.onBlockPlaced(world, pos, state, player, (AbstractMachineEntity)te);
        te.setAdvanced(this.advanced);
    }

    @Deprecated
    public int func_180656_a(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        TilePowerMonitor te = (TilePowerMonitor)this.getTileEntity(blockAccess, pos);
        if (te != null) {
            return te.getRedstoneLevel();
        }
        return super.func_180656_a(blockStateIn, blockAccess, pos, side);
    }

    public boolean func_149744_f(@Nonnull IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        TilePowerMonitor te = (TilePowerMonitor)this.getTileEntitySafe(world, pos);
        if (te != null) {
            return te.isEngineControlEnabled();
        }
        return super.canConnectRedstone(state, world, pos, side);
    }

    @Deprecated
    public boolean func_176225_a(@Nonnull IBlockState bs, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        if (!super.func_176225_a(bs, worldIn, pos, side)) {
            return false;
        }
        if (!this.advanced) {
            return true;
        }
        TilePowerMonitor tileEntity = (TilePowerMonitor)this.getTileEntitySafe(worldIn, pos);
        if (tileEntity == null) {
            return true;
        }
        if (tileEntity.getFacing() != side) {
            return true;
        }
        return tileEntity.getPaintSource() == null;
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TilePowerMonitor.class, (TileEntitySpecialRenderer)new TESRPowerMonitor());
    }

    public void onNeighborChange(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull BlockPos neighbor) {
        FuncUtil.doIf((Object)this.getTileEntitySafe(world, pos), te -> te.onNeighbor());
        super.onNeighborChange(world, pos, neighbor);
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        FuncUtil.doIf((Object)this.getTileEntitySafe((IBlockAccess)worldIn, pos), te -> te.onNeighbor());
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }
}

