/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.packet;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.powertools.machine.capbank.packet.PacketCapBank;
import crazypants.enderio.util.EnumReader;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGuiChange
extends PacketCapBank<PacketGuiChange, IMessage> {
    private int maxSend;
    private int maxRec;
    @Nonnull
    private RedstoneControlMode inputMode = RedstoneControlMode.OFF;
    @Nonnull
    private RedstoneControlMode outputMode = RedstoneControlMode.OFF;

    public PacketGuiChange() {
    }

    public PacketGuiChange(@Nonnull TileCapBank capBank) {
        super(capBank);
        ICapBankNetwork network = capBank.getNetwork();
        this.maxSend = network.getMaxOutput();
        this.maxRec = network.getMaxInput();
        this.inputMode = network.getInputControlMode();
        this.outputMode = network.getOutputControlMode();
        if (((Boolean)DiagnosticsConfig.debugTraceCapLimitsExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("CapBankNetwork ").append(network).append(" sending network package in=").append(this.maxRec).append(" out=").append(this.maxSend);
            for (StackTraceElement elem : new Exception("Stackstrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn((Object[])new Object[]{sb});
        }
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.maxSend);
        buf.writeInt(this.maxRec);
        buf.writeShort(this.inputMode.ordinal());
        buf.writeShort(this.outputMode.ordinal());
    }

    public void read(ByteBuf buf) {
        this.maxSend = buf.readInt();
        this.maxRec = buf.readInt();
        this.inputMode = (RedstoneControlMode)EnumReader.get(RedstoneControlMode.class, (int)buf.readShort());
        this.outputMode = (RedstoneControlMode)EnumReader.get(RedstoneControlMode.class, (int)buf.readShort());
    }

    @Override
    @Nullable
    protected IMessage handleMessage(TileCapBank te, PacketGuiChange message, MessageContext ctx) {
        ICapBankNetwork net = te.getNetwork();
        if (net == null) {
            return null;
        }
        net.setMaxOutput(message.maxSend);
        net.setMaxInput(message.maxRec);
        net.setInputControlMode(message.inputMode);
        net.setOutputControlMode(message.outputMode);
        return null;
    }
}

