/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import crazypants.enderio.util.EnumReader;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneConduitSignalColor
extends AbstractConduitPacket.Sided<IRedstoneConduit> {
    @Nonnull
    private DyeColor col = DyeColor.BLACK;
    private boolean isInput;

    public PacketRedstoneConduitSignalColor() {
    }

    public PacketRedstoneConduitSignalColor(@Nonnull IRedstoneConduit con, @Nonnull EnumFacing dir, boolean isInput) {
        super(con, dir);
        this.col = isInput ? con.getInputSignalColor(dir) : con.getOutputSignalColor(dir);
        this.isInput = isInput;
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeShort(this.col.ordinal());
        buf.writeBoolean(this.isInput);
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.col = (DyeColor)EnumReader.get(DyeColor.class, (int)buf.readShort());
        this.isInput = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketRedstoneConduitSignalColor, IMessage> {
        public IMessage onMessage(PacketRedstoneConduitSignalColor message, MessageContext ctx) {
            IRedstoneConduit conduit = (IRedstoneConduit)message.getConduit(ctx);
            if (conduit != null) {
                if (message.isInput) {
                    conduit.setInputSignalColor(message.dir, message.col);
                } else {
                    conduit.setOutputSignalColor(message.dir, message.col);
                }
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }
    }
}

