/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.gui.RedstoneModeButton;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.gui.BaseSettingsPanel;
import crazypants.enderio.conduits.gui.ConduitRedstoneModeControlable;
import crazypants.enderio.conduits.gui.GuiExternalConnection;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.network.PacketExtractMode;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PowerSettings
extends BaseSettingsPanel {
    private static final int ID_REDSTONE_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private IPowerConduit conduit;
    private RedstoneModeButton<?> rsB;
    private ColorButton colorB;

    public PowerSettings(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        super((IWidgetIcon)IconEIO.WRENCH_OVERLAY_POWER, ConduitObject.item_power_conduit.getUnlocalisedName(), gui, con, "in_out_settings");
        this.conduit = (IPowerConduit)con;
        int x = this.rightColumn;
        int y = this.customTop;
        int x0 = x + 20;
        this.colorB = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x0, y);
        this.colorB.setToolTipHeading(Lang.GUI_SIGNAL_COLOR.get());
        this.colorB.setColorIndex(this.conduit.getExtractionSignalColor(gui.getDir()).ordinal());
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, ID_REDSTONE_BUTTON, x, y, (IRedstoneModeControlable)new ConduitRedstoneModeControlable(this.conduit, gui, this.colorB));
    }

    @Override
    public void actionPerformed(@Nonnull GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_COLOR_BUTTON) {
            this.conduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.fromIndex((int)this.colorB.getColorIndex()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.conduit, this.gui.getDir()));
        }
    }

    @Override
    protected void initCustomOptions() {
        super.initCustomOptions();
        this.rsB.onGuiInit();
        this.rsB.setMode(RedstoneControlMode.IconHolder.getFromMode((RedstoneControlMode)this.conduit.getExtractionRedstoneMode(this.gui.getDir())));
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.rsB.detach();
        this.colorB.detach();
    }
}

