/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.filter.network.IOpenFilterRemoteExec;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.gui.FakeButton;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.network.PacketConnectionMode;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BaseSettingsPanel
extends Gui
implements ITabPanel,
IOpenFilterRemoteExec.GUI {
    static final int ID_INSERT_ENABLED = 327;
    static final int ID_EXTRACT_ENABLED = 328;
    protected static final int ID_INSERT_FILTER_OPTIONS = 329;
    protected static final int ID_EXTRACT_FILTER_OPTIONS = 330;
    protected final int ID_ENABLED = 331;
    @Nonnull
    protected final IWidgetIcon icon;
    @Nonnull
    protected final IGuiExternalConnection gui;
    @Nonnull
    protected IClientConduit con;
    @Nonnull
    protected final String typeName;
    @Nonnull
    protected final ResourceLocation texture;
    protected ConnectionMode oldConnectionMode;
    @Nonnull
    private String inputHeading;
    @Nonnull
    private String outputHeading;
    private boolean insertEnabled = false;
    private boolean extractEnabled = false;
    private boolean enabled = false;
    @Nonnull
    private final CheckBox extractEnabledB;
    @Nonnull
    private final CheckBox insertEnabledB;
    @Nonnull
    private final CheckBox enabledB;
    @Nonnull
    private IconButton insertFilterOptionsB;
    @Nonnull
    private IconButton extractFilterOptionsB;
    @Nonnull
    private FakeButton functionUpgradeOptionsB;
    protected int left = 0;
    protected int top = 0;
    protected int width = 0;
    protected int height = 0;
    protected int rightColumn = 112;
    protected int leftColumn = 22;
    protected int gap = 5;
    protected int customTop = 0;
    @Nonnull
    private final GuiToolTip functionUpgradeTooltip;
    @Nonnull
    protected GuiToolTip filterExtractUpgradeTooltip;
    @Nonnull
    protected GuiToolTip filterInsertUpgradeTooltip;

    protected BaseSettingsPanel(@Nonnull IWidgetIcon icon, @Nonnull String typeName, final @Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con, @Nonnull String texture) {
        this.icon = icon;
        this.typeName = typeName;
        this.gui = gui;
        this.con = con;
        this.texture = EnderIO.proxy.getGuiTexture(texture);
        this.inputHeading = this.getInputHeading();
        this.outputHeading = this.getOutputHeading();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        this.customTop = this.top + this.gap * 5 + fr.field_78288_b * 2;
        this.customTop -= 16;
        int x = this.leftColumn;
        int y = 6;
        this.insertEnabledB = new CheckBox((IGuiScreen)gui, 327, x, y);
        this.enabledB = new CheckBox((IGuiScreen)gui, 331, x, y);
        x = this.rightColumn;
        this.extractEnabledB = new CheckBox((IGuiScreen)gui, 328, x, y);
        x = this.leftColumn;
        y = 92;
        this.insertFilterOptionsB = new IconButton((IGuiScreen)gui, 329, x, y, (IWidgetIcon)IconEIO.GEAR_LIGHT);
        this.insertFilterOptionsB.setToolTip(new String[]{crazypants.enderio.base.lang.Lang.GUI_EDIT_ITEM_FILTER.get()});
        x = this.rightColumn;
        this.extractFilterOptionsB = new IconButton((IGuiScreen)gui, 330, x, y, (IWidgetIcon)IconEIO.GEAR_LIGHT);
        this.extractFilterOptionsB.setToolTip(new String[]{crazypants.enderio.base.lang.Lang.GUI_EDIT_ITEM_FILTER.get()});
        x = this.rightColumn + 18 + 1;
        this.functionUpgradeOptionsB = new FakeButton((IGuiScreen)gui, x, y, (IWidgetIcon)IconEIO.INFO){

            public boolean isVisible() {
                return BaseSettingsPanel.this.hasUpgrades() && super.isVisible();
            }
        };
        this.functionUpgradeOptionsB.setToolTip(new GuiToolTip(new Rectangle(x, y, 18, 18), new String[]{""}){

            public boolean shouldDraw() {
                return BaseSettingsPanel.this.hasUpgrades() && super.shouldDraw();
            }

            @Nonnull
            public List<String> getToolTipText() {
                return gui.getContainer().getFunctionUpgradeToolTipText();
            }
        });
        this.filterExtractUpgradeTooltip = new GuiToolTip(new Rectangle(this.rightColumn, 70, 18, 18), new String[]{Lang.GUI_ITEM_FILTER_UPGRADE.get()}){

            public boolean shouldDraw() {
                return !gui.getContainer().hasFilter(false) && super.shouldDraw();
            }
        };
        this.filterInsertUpgradeTooltip = new GuiToolTip(new Rectangle(this.leftColumn, 70, 18, 18), new String[]{Lang.GUI_ITEM_FILTER_UPGRADE.get()}){

            public boolean shouldDraw() {
                return !gui.getContainer().hasFilter(true) && super.shouldDraw();
            }
        };
        this.functionUpgradeTooltip = new GuiToolTip(new Rectangle(this.rightColumn + 18, this.customTop + 43, 18, 18), new String[]{Lang.GUI_ITEM_FUNCTION_UPGRADE.get(), Lang.GUI_ITEM_FUNCTION_UPGRADE_2.get(), Lang.GUI_ITEM_FUNCTION_UPGRADE_3.get()}){

            public boolean shouldDraw() {
                return !gui.getContainer().hasFunctionUpgrade() && super.shouldDraw();
            }
        };
        gui.getContainer().setInOutSlotsVisible(false, false, (IConduit)con);
    }

    protected void updateFilterButtons() {
        if (this.gui.getContainer().hasFilter(true) && this.hasFilterGui(true)) {
            this.insertFilterOptionsB.setIsVisible(true);
        } else {
            this.insertFilterOptionsB.setIsVisible(false);
        }
        if (this.gui.getContainer().hasFilter(false) && this.hasFilterGui(false)) {
            this.extractFilterOptionsB.setIsVisible(true);
        } else {
            this.extractFilterOptionsB.setIsVisible(false);
        }
    }

    protected boolean hasFilterGui(boolean input) {
        return true;
    }

    public boolean updateConduit(@Nonnull IClientConduit conduit) {
        this.con = conduit;
        if (this.oldConnectionMode != this.con.getConnectionMode(this.gui.getDir())) {
            this.connectionModeChanged(this.con.getConnectionMode(this.gui.getDir()));
        }
        return true;
    }

    public void onGuiInit(int leftIn, int topIn, int widthIn, int heightIn) {
        this.left = leftIn;
        this.top = topIn;
        this.width = widthIn;
        this.height = heightIn;
        this.updateConduit(this.con);
        if (this.hasInOutModes()) {
            this.insertEnabledB.onGuiInit();
            this.extractEnabledB.onGuiInit();
            this.insertEnabledB.setSelected(this.insertEnabled);
            this.extractEnabledB.setSelected(this.extractEnabled);
        } else {
            this.enabledB.onGuiInit();
            this.enabledB.setSelected(this.enabled);
        }
        if (this.hasFilters()) {
            this.gui.addToolTip(this.filterExtractUpgradeTooltip);
            this.gui.addToolTip(this.filterInsertUpgradeTooltip);
            this.insertFilterOptionsB.onGuiInit();
            this.extractFilterOptionsB.onGuiInit();
            this.insertFilterOptionsB.setIsVisible(false);
            this.extractFilterOptionsB.setIsVisible(false);
        }
        if (this.hasUpgrades()) {
            this.gui.addToolTip(this.functionUpgradeTooltip);
            this.functionUpgradeOptionsB.onGuiInit();
        }
        this.initCustomOptions();
    }

    protected boolean hasUpgrades() {
        return false;
    }

    protected void initCustomOptions() {
    }

    public void deactivate() {
        this.insertEnabledB.detach();
        this.extractEnabledB.detach();
        this.insertFilterOptionsB.detach();
        this.extractFilterOptionsB.detach();
        this.functionUpgradeOptionsB.detach();
        this.gui.removeToolTip(this.functionUpgradeTooltip);
        this.gui.removeToolTip(this.filterExtractUpgradeTooltip);
        this.gui.removeToolTip(this.filterInsertUpgradeTooltip);
    }

    public void mouseClicked(int x, int y, int par3) {
    }

    public void keyTyped(char par1, int par2) {
    }

    public void updateScreen() {
    }

    @Nonnull
    public IWidgetIcon getIcon() {
        return this.icon;
    }

    @Nonnull
    public ResourceLocation getTexture() {
        return this.texture;
    }

    private void updateConnectionMode() {
        ConnectionMode mode = ConnectionMode.DISABLED;
        if (this.insertEnabled && this.extractEnabled || this.enabled) {
            mode = ConnectionMode.IN_OUT;
        } else if (this.insertEnabled) {
            mode = ConnectionMode.OUTPUT;
        } else if (this.extractEnabled) {
            mode = ConnectionMode.INPUT;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConnectionMode((IConduit)this.con, this.gui.getDir(), mode));
    }

    public void actionPerformed(@Nonnull GuiButton guiButton) {
        if (guiButton.field_146127_k == 327) {
            this.insertEnabled = !this.insertEnabled;
            this.updateConnectionMode();
        } else if (guiButton.field_146127_k == 328) {
            this.extractEnabled = !this.extractEnabled;
            this.updateConnectionMode();
        } else if (guiButton.field_146127_k == 331) {
            this.enabled = !this.enabled;
            this.updateConnectionMode();
        }
    }

    protected void connectionModeChanged(@Nonnull ConnectionMode mode) {
        this.oldConnectionMode = mode;
        if (this.hasInOutModes()) {
            this.insertEnabled = mode.acceptsOutput();
            this.extractEnabled = mode.acceptsInput();
        } else {
            this.enabled = mode == ConnectionMode.IN_OUT;
        }
    }

    public void render(float par1, int par2, int par3) {
        this.updateFilterButtons();
        FontRenderer fr = this.gui.getFontRenderer();
        int rgb = ColorUtil.getRGB((Color)Color.darkGray);
        int x = this.left + 32;
        int y = this.gui.getGuiTop() + 10;
        if (this.hasInOutModes()) {
            fr.func_78276_b(this.inputHeading, x, y, rgb);
            fr.func_78276_b(this.outputHeading, x += 92, y, rgb);
        } else {
            String heading = this.enabled ? this.getEnabledHeading() : this.getDisabledHeading();
            fr.func_78276_b(heading, x, y, rgb);
        }
        this.renderCustomOptions(y + this.gap + fr.field_78288_b + this.gap, par1, par2, par3);
    }

    protected void renderCustomOptions(int topIn, float par1, int par2, int par3) {
    }

    @Nonnull
    protected String getTypeName() {
        return this.typeName;
    }

    protected boolean hasFilters() {
        return false;
    }

    public void setGuiID(int id) {
        this.gui.setGuiID(id);
    }

    public int getGuiID() {
        return this.gui.getGuiID();
    }

    @Nonnull
    protected String getInputHeading() {
        return Lang.GUI_CONDUIT_INSERT_MODE.get();
    }

    @Nonnull
    protected String getOutputHeading() {
        return Lang.GUI_CONDUIT_EXTRACT_MODE.get();
    }

    @Nonnull
    protected String getEnabledHeading() {
        return Lang.GUI_CONDUIT_ENABLED_MODE.get();
    }

    @Nonnull
    protected String getDisabledHeading() {
        return Lang.GUI_CONDUIT_DISABLED_MODE.get();
    }

    protected boolean hasInOutModes() {
        return true;
    }
}

