/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import crazypants.enderio.base.power.PerTickIntAverageCalculator;

public class PowerTracker {
    private long previousStorageLevel = -1L;
    private final PerTickIntAverageCalculator recTracker = new PerTickIntAverageCalculator();
    private final PerTickIntAverageCalculator sentTracker = new PerTickIntAverageCalculator();
    private int sentThisTick = 0;
    private int recievedThisTick = 0;

    public void tickStart(long storedEnergy) {
        long curStorage = storedEnergy;
        if (this.previousStorageLevel > -1L) {
            long recieved = curStorage - this.previousStorageLevel;
            recieved = Math.max(0L, recieved);
            this.recievedThisTick += (int)recieved;
        }
    }

    public void powerRecieved(int power) {
        this.recievedThisTick += power;
    }

    public void powerSent(int power) {
        this.sentThisTick += power;
    }

    public void tickEnd(long storedEnergy) {
        this.previousStorageLevel = storedEnergy;
        this.sentTracker.tick((long)this.sentThisTick);
        this.recTracker.tick((long)this.recievedThisTick);
        this.recievedThisTick = 0;
        this.sentThisTick = 0;
    }

    public float getAverageRfTickRecieved() {
        return this.recTracker.getAverage();
    }

    public float getAverageRfTickSent() {
        return this.sentTracker.getAverage();
    }
}

