/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.autosave;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.util.NbtValue;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.java.util.HandleSimpleCollection;
import info.loenwind.autosave.util.NBTAction;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleIConduit
implements IHandler<IConduit> {
    @Nonnull
    public Class<?> getRootType() {
        return IConduit.class;
    }

    public boolean store(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull Type type, @Nonnull String name, @Nonnull IConduit object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (object instanceof IServerConduit) {
            NBTTagCompound root = new NBTTagCompound();
            ConduitUtil.writeToNBT((IServerConduit)((IServerConduit)object), (NBTTagCompound)root);
            nbt.func_74782_a(name, (NBTBase)root);
        } else {
            Log.error((Object[])new Object[]{"Logic error: Attempting to store client conduit procy as NBT for phase(S) " + phase});
        }
        return true;
    }

    public IConduit read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull Type type, @Nonnull String name, @Nullable IConduit object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound conduitTag;
        NBTTagCompound root;
        if (nbt.func_74764_b(name) && (object = this.read(phase, root = nbt.func_74775_l(name))) == null && (conduitTag = NbtValue.CONDUIT.getTag(root)) != null) {
            object = this.read(phase, conduitTag);
        }
        return object;
    }

    private IConduit read(@Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound conduitTag) {
        return phase.contains(NBTAction.CLIENT) ? ConduitUtil.readClientConduitFromNBT((NBTTagCompound)conduitTag) : ConduitUtil.readConduitFromNBT((NBTTagCompound)conduitTag);
    }

    public static class List
    extends HandleSimpleCollection<CopyOnWriteArrayList<IConduit>> {
        public List() throws NoHandlerFoundException {
            super(CopyOnWriteArrayList.class);
        }

        protected List(Registry registry) throws NoHandlerFoundException {
            super(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new, registry, new Type[]{IConduit.class});
        }

        protected IHandler<? extends CopyOnWriteArrayList<IConduit>> create(@Nonnull Registry registry, Type ... types) throws NoHandlerFoundException {
            if (types[0] == IConduit.class) {
                return new List(registry);
            }
            return null;
        }

        public CopyOnWriteArrayList<IConduit> read(@Nonnull Registry registry, @Nonnull Set<NBTAction> phase, @Nonnull NBTTagCompound nbt, @Nonnull Type type, @Nonnull String name, @Nullable CopyOnWriteArrayList<IConduit> object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
            CopyOnWriteArrayList result = (CopyOnWriteArrayList)super.read(registry, phase, nbt, type, name, object);
            if (result != null) {
                while (result.remove(null)) {
                }
            }
            return result;
        }
    }
}

