/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.window;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.ElecCore;
import elec332.core.inventory.widget.slot.WidgetSlot;
import elec332.core.inventory.window.IWindowContainer;
import elec332.core.inventory.window.IWindowListener;
import elec332.core.inventory.window.Window;
import elec332.core.inventory.window.WindowGui;
import elec332.core.inventory.window.WrappedWidgetSlot;
import elec332.core.network.packets.PacketWindowData;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class WindowContainer
extends Container {
    private final Window window;
    private final EntityPlayer thePlayer;
    private final List<IWindowListener> listeners = Lists.newArrayList();
    private final Map<WidgetSlot, Slot> slotStuff;
    private final Map<Slot, WidgetSlot> externalSlots;
    final WindowContainerHandler windowContainerHandler;
    private static final IInventory NULL_INVENTORY = new InventoryBasic("NULL", false, 0);

    public WindowContainer(EntityPlayer player, Window window) {
        this.thePlayer = player;
        this.window = window;
        this.slotStuff = Maps.newHashMap();
        this.externalSlots = Maps.newHashMap();
        this.windowContainerHandler = new WindowContainerHandler();
        window.setContainer(this.windowContainerHandler);
        if (!player.func_130014_f_().field_72995_K) {
            window.initWindow_();
        }
    }

    public Window getWindow() {
        return this.window;
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        WindowListener windowListener = new WindowListener(listener);
        this.window.onListenerAdded(windowListener);
        if (!this.listeners.contains(listener)) {
            this.listeners.add(windowListener);
        }
    }

    public void func_82847_b(@Nonnull IContainerListener listener) {
        super.func_82847_b(listener);
        this.listeners.remove(listener);
    }

    public void func_75137_b(int id, int data) {
        this.window.updateProgressBar(id, data);
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.window.detectAndSendChanges(this);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return this.window.transferStackInSlot(playerIn, index);
    }

    public void func_75134_a(EntityPlayer player) {
        this.window.onWindowClosed(player);
        super.func_75134_a(player);
    }

    public void func_75141_a(int slotID, @Nonnull ItemStack stack) {
        this.window.putStackInSlot(slotID, stack);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return this.window.slotClick(slotId, dragType, clickTypeIn, player);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        if (slotIn instanceof WidgetLinkedSlot) {
            return this.window.canMergeSlot(stack, ((WidgetLinkedSlot)slotIn).widget);
        }
        return super.func_94530_a(stack, slotIn);
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.window.onCraftMatrixChanged(inventoryIn);
    }

    public boolean func_75129_b(@Nonnull EntityPlayer player) {
        return this.window.getCanCraft(player);
    }

    public void func_75128_a(@Nonnull EntityPlayer player, boolean canCraft) {
        this.window.setCanCraft(player, canCraft);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return this.window.canInteractWith(player);
    }

    protected Slot func_75146_a(Slot slotIn) {
        if (!(slotIn instanceof WidgetLinkedSlot)) {
            this.externalSlots.put(slotIn, new WrappedWidgetSlot(slotIn));
        }
        return super.func_75146_a(slotIn);
    }

    class WindowContainerHandler
    implements IWindowContainer {
        @SideOnly(value=Side.CLIENT)
        WindowGui windowGui;

        WindowContainerHandler() {
        }

        @Override
        public WidgetSlot getSlot(int id) {
            Slot unknown;
            Slot slot = unknown = id >= 0 && id < WindowContainer.this.field_75151_b.size() ? WindowContainer.this.func_75139_a(id) : null;
            if (unknown instanceof WidgetLinkedSlot) {
                return ((WidgetLinkedSlot)unknown).widget;
            }
            return (WidgetSlot)Preconditions.checkNotNull(WindowContainer.this.externalSlots.get(unknown));
        }

        @Override
        public int getSlotListSize() {
            return WindowContainer.this.field_75151_b.size();
        }

        @Override
        @Nonnull
        public <T extends WidgetSlot> T addSlotToWindow(@Nonnull T widget) {
            WidgetLinkedSlot slot = new WidgetLinkedSlot(widget);
            WindowContainer.this.func_75146_a(slot);
            WindowContainer.this.slotStuff.put(widget, slot);
            return widget;
        }

        @Override
        public void detectAndSendChanges() {
            WindowContainer.this.func_75142_b();
        }

        @Override
        public EntityPlayer getPlayer() {
            return WindowContainer.this.thePlayer;
        }

        @Override
        public List<IWindowListener> getListeners() {
            return WindowContainer.this.listeners;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleMouseClickDefault(WidgetSlot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
            Slot slot;
            Slot slot2 = slot = slotIn == null ? null : (Slot)WindowContainer.this.slotStuff.get(slotIn);
            if (slotIn != null && slot == null) {
                throw new IllegalArgumentException();
            }
            this.windowGui.handleMouseClickDefault(slot, slotId, mouseButton, type);
        }

        @Override
        public boolean mergeItemStackDefault(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
            return WindowContainer.super.func_75135_a(stack, startIndex, endIndex, reverseDirection);
        }

        @Override
        public ItemStack slotClickDefault(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
            return WindowContainer.super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }

        @Override
        public void sendPacket(NBTTagCompound tag) {
            PacketWindowData packet = new PacketWindowData(WindowContainer.this, tag);
            if (!((WindowContainer)WindowContainer.this).thePlayer.func_130014_f_().field_72995_K) {
                ElecCore.networkHandler.sendTo(packet, (EntityPlayerMP)WindowContainer.this.thePlayer);
            } else {
                ElecCore.networkHandler.sendToServer(packet);
            }
        }

        @Override
        public int getWindowID() {
            return WindowContainer.this.field_75152_c;
        }
    }

    class WidgetLinkedSlot
    extends Slot {
        final WidgetSlot widget;

        private WidgetLinkedSlot(WidgetSlot widget) {
            super(NULL_INVENTORY, widget.getSlotIndex(), widget.x, widget.y);
            this.widget = widget;
        }

        public void func_75220_a(ItemStack oldStack, ItemStack newStack) {
            this.widget.onSlotChange(oldStack, newStack);
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.widget.onCrafting(stack, amount);
        }

        protected void func_190900_b(int p_190900_1_) {
            this.widget.onSwapCraft(p_190900_1_);
        }

        protected void func_75208_c(ItemStack stack) {
            this.widget.onCrafting(stack);
        }

        @Nonnull
        public ItemStack func_190901_a(@Nonnull EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            return this.widget.onTake(thePlayer, stack);
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.widget.isItemValid(stack);
        }

        @Nonnull
        public ItemStack func_75211_c() {
            return this.widget.getStack();
        }

        public boolean func_75216_d() {
            return this.widget.getHasStack();
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            this.widget.putStack(stack);
        }

        public void func_75218_e() {
            this.widget.onSlotChanged();
        }

        public int func_75219_a() {
            return this.widget.getSlotStackLimit();
        }

        public int func_178170_b(ItemStack stack) {
            return this.widget.getItemStackLimit(stack);
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        public String func_178171_c() {
            return this.widget.getSlotTexture();
        }

        @Nonnull
        public ItemStack func_75209_a(int amount) {
            return this.widget.decrStackSize(amount);
        }

        public boolean func_75217_a(IInventory inv, int slotIn) {
            return this.widget.isHere(inv, slotIn);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return this.widget.canTakeStack(playerIn);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.widget.canBeHovered();
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getBackgroundLocation() {
            return this.widget.getBackgroundLocation();
        }

        @SideOnly(value=Side.CLIENT)
        public void setBackgroundLocation(@Nonnull ResourceLocation texture) {
            this.widget.setBackgroundLocation(texture);
        }

        public void setBackgroundName(@Nonnull String name) {
            this.widget.setBackgroundName(name);
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getBackgroundSprite() {
            return this.widget.getBackgroundSprite();
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        protected TextureMap getBackgroundMap() {
            return this.widget.getBackgroundMap();
        }

        public int getSlotIndex() {
            return this.widget.getSlotIndex();
        }

        public boolean isSameInventory(Slot other) {
            return this.widget.isSameInventory(((WidgetLinkedSlot)other).widget);
        }
    }

    private class WindowListener
    implements IWindowListener {
        private final IContainerListener listener;

        private WindowListener(IContainerListener listener) {
            this.listener = listener;
        }

        @Override
        public void updateCraftingInventory(List<ItemStack> itemsList) {
            if (!(itemsList instanceof NonNullList)) {
                throw new IllegalArgumentException();
            }
            this.listener.func_71110_a((Container)WindowContainer.this, (NonNullList)itemsList);
        }

        @Override
        public void sendSlotContents(int slotInd, ItemStack stack) {
            this.listener.func_71111_a((Container)WindowContainer.this, slotInd, stack);
        }

        @Override
        public void sendProgressBarUpdate(int id, int newValue) {
            this.listener.func_71112_a((Container)WindowContainer.this, id, newValue);
        }

        @Override
        public Object getActualListener() {
            return this.listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof WindowListener && ((WindowListener)obj).listener.equals(this.listener) || obj instanceof IContainerListener && obj.equals(this.listener);
        }
    }
}

