/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.tooltip;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import elec332.core.client.RenderHelper;
import elec332.core.util.ItemStackHelper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolTip {
    private int width = -1;
    private final List<String> tooltip;

    public ToolTip() {
        this(Collections.emptyList());
    }

    public ToolTip(ColouredString colouredString) {
        this(Lists.newArrayList((Object[])new ColouredString[]{colouredString}));
    }

    public ToolTip(List<ColouredString> s) {
        this.tooltip = s.stream().map(ColouredString::toString).collect(Collectors.toList());
    }

    public ToolTip(String s) {
        this(Lists.newArrayList((Object[])new String[]{s}), new Object[0]);
    }

    public ToolTip(List<String> s, Object ... o) {
        this.tooltip = s;
    }

    public ToolTip setWidth(int width) {
        this.width = width;
        return this;
    }

    public List<String> getTooltip() {
        return this.tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int mouseX, int mouseY, int guiLeft, int guiTop) {
        this.renderTooltip(mouseX, mouseY, guiLeft, guiTop, ItemStackHelper.NULL_STACK);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int mouseX, int mouseY, int guiLeft, int guiTop, @Nonnull ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.drawHoveringText((ItemStack)((ItemStack)Preconditions.checkNotNull((Object)stack)), this.tooltip, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)this.width, (FontRenderer)RenderHelper.getMCFontrenderer());
    }

    public static class ColouredString {
        private final String string;

        public ColouredString(String s) {
            this(TextFormatting.GRAY, s);
        }

        public ColouredString(TextFormatting colour, String s) {
            this.string = colour + s;
        }

        public String toString() {
            return this.string;
        }
    }
}

