/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.info;

import elec332.core.api.info.IInfoDataAccessorBlock;
import elec332.core.api.info.IInfoProvider;
import elec332.core.api.info.IInformation;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;

public abstract class AbstractInfoProviderCapability<O>
implements IInfoProvider {
    private final Capability<O> capability;

    public AbstractInfoProviderCapability(Capability<O> capability) {
        this.capability = capability;
    }

    @Override
    public final void addInformation(@Nonnull IInformation information, @Nonnull IInfoDataAccessorBlock hitData) {
        Object cap;
        TileEntity tile = hitData.getTileEntity();
        if (tile != null && tile.hasCapability(this.capability, hitData.getSide()) && (cap = tile.getCapability(this.capability, hitData.getSide())) != null) {
            this.addInformation(information, hitData, cap);
        }
    }

    @Override
    @Nonnull
    public final NBTTagCompound getInfoNBTData(@Nonnull NBTTagCompound tag, TileEntity tile, @Nonnull EntityPlayerMP player, @Nonnull IInfoDataAccessorBlock hitData) {
        Object cap;
        if (tile != null && tile.hasCapability(this.capability, hitData.getSide()) && (cap = tile.getCapability(this.capability, hitData.getSide())) != null) {
            this.getNBTData(tag, tile, cap, player, hitData);
        }
        return tag;
    }

    public abstract void addInformation(@Nonnull IInformation var1, @Nonnull IInfoDataAccessorBlock var2, O var3);

    @Nonnull
    public abstract NBTTagCompound getNBTData(@Nonnull NBTTagCompound var1, TileEntity var2, O var3, @Nonnull EntityPlayerMP var4, @Nonnull IInfoDataAccessorBlock var5);
}

