/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.simplequarry.vortex;

import com.zeitheron.hammercore.client.particle.api.ParticleList;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.math.MathHelper;
import java.util.List;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.zeith.simplequarry.SimpleQuarry;
import org.zeith.simplequarry.client.particle.ParticleBlock;
import org.zeith.simplequarry.tile.TileFuelQuarry;
import org.zeith.simplequarry.vortex.Vortex;

public class QuarryVortex
extends Vortex {
    public final TileFuelQuarry quarry;
    public WorldLocation loc;
    public int ticksExisted = 0;

    public QuarryVortex(TileFuelQuarry quarry) {
        super(quarry.func_145831_w().field_73011_w.getDimension(), (double)quarry.func_174877_v().func_177958_n() + 0.5, (double)quarry.func_174877_v().func_177956_o() + 0.5, (double)quarry.func_174877_v().func_177952_p() + 0.5, 16.0, false);
        this.loc = quarry.getLocation();
        this.quarry = quarry;
    }

    @Override
    public void func_73660_a() {
        double pz;
        double py;
        double px;
        double mz;
        double my;
        double mx;
        Particle p;
        int i;
        if (this.loc.getTileOfType(TileFuelQuarry.class) != this.quarry) {
            SimpleQuarry.proxy.removeParticleVortex(this);
            return;
        }
        World world = this.loc.getWorld();
        BlockPos pos = this.loc.getPos();
        if (this.getBoundingBox() == null) {
            return;
        }
        List particles = ParticleList.getParticlesWithinAABB((AxisAlignedBB)this.getBoundingBox());
        for (i = 0; i < particles.size(); ++i) {
            p = (Particle)particles.get(i);
            mx = p.field_187129_i;
            my = p.field_187130_j;
            mz = p.field_187131_k;
            px = p.field_187126_f;
            py = p.field_187127_g;
            pz = p.field_187128_h;
            double dx = px - this.x;
            double dy = py - this.y;
            double dz = pz - this.z;
            double distX = Math.sqrt(dx * dx);
            double distY = Math.sqrt(dy * dy);
            double distZ = Math.sqrt(dz * dz);
            mx = MathHelper.clip((double)(this.x - px), (double)-1.0, (double)1.0) / (8.0 / distX);
            my = MathHelper.clip((double)(this.y - py - 0.7), (double)-1.0, (double)1.0) / (8.0 / distY);
            mz = MathHelper.clip((double)(this.z - pz), (double)-1.0, (double)1.0) / (8.0 / distZ);
            p.field_187129_i = mx;
            p.field_187130_j = my;
            p.field_187131_k = mz;
        }
        particles = ParticleList.getParticlesWithinAABB((AxisAlignedBB)new AxisAlignedBB(pos.func_177977_b()));
        for (i = 0; i < particles.size(); ++i) {
            p = (Particle)particles.get(i);
            mx = p.field_187129_i;
            my = p.field_187130_j;
            mz = p.field_187131_k;
            px = p.field_187126_f;
            py = p.field_187127_g;
            pz = p.field_187128_h;
            mx = MathHelper.clip((double)(this.x - px), (double)-1.0, (double)1.0) / 4.0;
            my = MathHelper.clip((double)(this.y - py), (double)-1.0, (double)1.0) / 32.0;
            mz = MathHelper.clip((double)(this.z - pz), (double)-1.0, (double)1.0) / 4.0;
            p.field_187129_i = mx;
            p.field_187130_j = my;
            p.field_187131_k = mz;
            if (!(p instanceof ParticleBlock)) continue;
            ParticleBlock pb = (ParticleBlock)p;
            pb.field_70546_d += 8;
            if (pb.field_70546_d < pb.field_70547_e) continue;
            pb.func_187112_i();
        }
        particles = ParticleList.getParticlesWithinAABB((AxisAlignedBB)new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
        for (i = 0; i < particles.size(); ++i) {
            p = (Particle)particles.get(i);
            p.func_187112_i();
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return this.quarry.boundingBox;
    }
}

