/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.simplequarry.tile;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.api.IChickenChunkLoader;
import codechicken.chunkloader.manager.ChunkLoaderManager;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import cofh.core.entity.FakePlayerCore;
import com.brandon3055.draconicevolution.blocks.DraconiumOre;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import java.util.Set;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.torgy.torgo.init.TorgoItems;
import org.torgy.torgo.network.ExternalPacketFXWispZap;
import org.zeith.simplequarry.SimpleQuarry;
import org.zeith.simplequarry.api.ItemInjector;
import org.zeith.simplequarry.api.energy.QuarryFuelStorage;
import org.zeith.simplequarry.blocks.BlockFuelQuarry;
import org.zeith.simplequarry.gui.c.ContainerFuelQuarry;
import org.zeith.simplequarry.gui.g.GuiFuelQuarry;
import org.zeith.simplequarry.vortex.QuarryVortex;
import scala.Int;

public class TileFuelQuarry
extends TileSyncableTickable
implements ITileDroppable,
IChickenChunkLoader {
    private final IBlockState frameWall = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("galacticraftplanets:miner_base"))).func_176223_P();
    private final IBlockState framePath = AsteroidBlocks.blockWalkway.func_176223_P();
    private final int QFtomBRatio = 5;
    private final int drainAmount = 1280;
    private final boolean flipper = false;
    public QuarryFuelStorage quarryFuel = new QuarryFuelStorage(512);
    public int tmpCounter = 0;
    public int attachedTankStored = 0;
    public boolean running = false;
    public InventoryDummy inv = new InventoryDummy(2);
    public AxisAlignedBB boundingBox;
    public QuarryVortex vortex;
    public boolean active = false;
    public long totalBlocksMined = 0L;
    protected int setupTickRate = 5;
    protected boolean loaded = false;
    FakePlayerCore fakePlayer;
    private int initLevel = 0;
    private int blocksPerQuarrySludge = 1024;
    private BlockPos quarryPos = null;
    private Chunk chunk = null;
    private boolean chunkLoaded = false;
    private BlockPos BL = null;
    private BlockPos TL = null;
    private BlockPos TR = null;
    private BlockPos BR = null;
    private int steps = 0;
    private int maxStepsX = 12;
    private int maxStepsY = 12;
    private boolean quarryInited = false;

    public double getFuelLevel() {
        return Math.abs((double)this.attachedTankStored / 5.0) + (double)this.quarryFuel.getStored();
    }

    private void destroyFluid(int y, IBlockState innerBlock) {
        BlockPos targetPosRight;
        int x;
        IBlockState boarderBlock = Blocks.field_150359_w.func_176223_P();
        BlockPos localPos = new BlockPos(this.getChunkCoord(this.chunk.field_76635_g), y, this.getChunkCoord(this.chunk.field_76647_h));
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos targetPos = localPos.func_177982_a(x, 0, z);
                Material material = this.field_145850_b.func_180495_p(targetPos).func_185904_a();
                if (!material.func_76224_d()) continue;
                this.field_145850_b.func_175656_a(targetPos, innerBlock);
            }
        }
        for (x = -1; x < 17; ++x) {
            BlockPos targetPosLeft = localPos.func_177982_a(x, 0, -1);
            targetPosRight = localPos.func_177982_a(x, 0, 16);
            if (this.field_145850_b.func_180495_p(targetPosLeft).func_185904_a().func_76224_d()) {
                this.field_145850_b.func_175656_a(targetPosLeft, boarderBlock);
            }
            if (!this.field_145850_b.func_180495_p(targetPosRight).func_185904_a().func_76224_d()) continue;
            this.field_145850_b.func_175656_a(targetPosRight, boarderBlock);
        }
        for (int z = -1; z < 17; ++z) {
            BlockPos targetPosLeft = localPos.func_177982_a(-1, 0, z);
            targetPosRight = localPos.func_177982_a(16, 0, z);
            if (this.field_145850_b.func_180495_p(targetPosLeft).func_185904_a().func_76224_d()) {
                this.field_145850_b.func_175656_a(targetPosLeft, boarderBlock);
            }
            if (!this.field_145850_b.func_180495_p(targetPosRight).func_185904_a().func_76224_d()) continue;
            this.field_145850_b.func_175656_a(targetPosRight, boarderBlock);
        }
    }

    public int getLevelsRemaining() {
        if (this.initLevel == 5) {
            return this.getCurPos(this.tmpCounter, this.quarryPos.func_177956_o(), 2).func_177956_o();
        }
        return 0;
    }

    private void initLevelNext() {
        ++this.initLevel;
        this.tmpCounter = 0;
    }

    private void initQuarry() {
        if (!this.quarryInited) {
            this.quarryPos = this.field_174879_c;
            this.chunk = this.field_145850_b.func_175726_f(this.quarryPos);
            this.BL = new BlockPos(this.getChunkCoord(this.chunk.field_76635_g), 0, this.getChunkCoord(this.chunk.field_76647_h));
            this.TL = new BlockPos(this.getChunkCoord(this.chunk.field_76635_g) + 15, 0, this.getChunkCoord(this.chunk.field_76647_h));
            this.TR = new BlockPos(this.getChunkCoord(this.chunk.field_76635_g) + 15, 0, this.getChunkCoord(this.chunk.field_76647_h) + 15);
            this.BR = new BlockPos(this.getChunkCoord(this.chunk.field_76635_g), 0, this.getChunkCoord(this.chunk.field_76647_h) + 15);
            this.quarryInited = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.fakePlayer = new FakePlayerCore((WorldServer)this.field_145850_b);
            this.activate();
        }
    }

    private int getChunkCoord(int x) {
        return x * 16;
    }

    private int getSafeY(int y) {
        return Math.min(Math.max(y, 1), 255);
    }

    private boolean canBreak(BlockPos pos) {
        IBlockState b = this.field_145850_b.func_180495_p(pos);
        return b != Blocks.field_150357_h.func_176223_P() && this.field_145850_b.func_175625_s(pos) == null && !this.field_145850_b.func_180495_p(pos).equals(this.frameWall) && !this.field_145850_b.func_180495_p(pos).equals(this.framePath);
    }

    public BlockPos getCurPos(int iteration, int topY, int bottomY) {
        int curY = topY - iteration / 256;
        if (curY < bottomY) {
            return null;
        }
        int curPosition = iteration % 256;
        int curX = curPosition / 16;
        int curZ = curPosition % 16;
        return new BlockPos(this.getChunkCoord(this.chunk.field_76635_g) + curX, curY, this.getChunkCoord(this.chunk.field_76647_h) + curZ);
    }

    private void clearSpace() {
        ItemStack itemStack;
        while (true) {
            BlockPos localPos;
            if ((localPos = this.getCurPos(this.tmpCounter, this.getSafeY(this.quarryPos.func_177956_o() + 3), this.quarryPos.func_177956_o())) == null) {
                this.sendChangesToNearby();
                this.initLevelNext();
                return;
            }
            ++this.tmpCounter;
            if (this.field_145850_b.func_175623_d(localPos)) continue;
            if (localPos.func_177956_o() == this.quarryPos.func_177956_o() + 3 && this.field_145850_b.func_180495_p(localPos).func_185904_a().func_76224_d()) {
                this.destroyFluid(localPos.func_177956_o() + 1, Blocks.field_150359_w.func_176223_P());
            }
            itemStack = this.generateDrops(localPos);
            if (this.destroyBlock(localPos, Blocks.field_150350_a.func_176223_P(), true, true) != null) break;
        }
        this.storeItem(itemStack);
    }

    private boolean createCrossPath() {
        BlockPos localPos = null;
        do {
            int startingPos = this.tmpCounter / 16;
            int posStep = this.tmpCounter % 16;
            switch (startingPos) {
                case 0: {
                    localPos = new BlockPos(this.quarryPos.func_177958_n(), this.getSafeY(this.quarryPos.func_177956_o() - 1), this.getChunkCoord(this.chunk.field_76647_h) + posStep);
                    break;
                }
                case 1: {
                    localPos = new BlockPos(this.getChunkCoord(this.chunk.field_76635_g) + posStep, this.getSafeY(this.quarryPos.func_177956_o() - 1), this.quarryPos.func_177952_p());
                    break;
                }
                default: {
                    this.initLevelNext();
                    return true;
                }
            }
            ++this.tmpCounter;
        } while (!this.canBreak(localPos));
        this.destroyBlock(localPos, this.framePath, true, true);
        return false;
    }

    private boolean createFrame(int localY, IBlockState iBlockState) {
        BlockPos localPos = null;
        do {
            int startingPos = this.tmpCounter / 16;
            int posStep = this.tmpCounter % 16;
            switch (startingPos) {
                case 0: {
                    localPos = this.BL.func_177982_a(0, localY, 0).func_177965_g(posStep);
                    break;
                }
                case 1: {
                    localPos = this.TL.func_177982_a(0, localY, 0).func_177970_e(posStep);
                    break;
                }
                case 2: {
                    localPos = this.TR.func_177982_a(0, localY, 0).func_177985_f(posStep);
                    break;
                }
                case 3: {
                    localPos = this.BR.func_177982_a(0, localY, 0).func_177964_d(posStep);
                    break;
                }
                default: {
                    this.initLevelNext();
                    return true;
                }
            }
            ++this.tmpCounter;
        } while (!this.canBreak(localPos));
        this.destroyBlock(localPos, iBlockState, true, true);
        return false;
    }

    private boolean createPillars() {
        int safeY = this.getSafeY(this.quarryPos.func_177956_o() + 3);
        BlockPos localPos = null;
        switch (this.tmpCounter) {
            case 0: {
                localPos = this.BL;
                break;
            }
            case 1: {
                localPos = this.TL;
                break;
            }
            case 2: {
                localPos = this.TR;
                break;
            }
            case 3: {
                localPos = this.BR;
                break;
            }
            default: {
                this.initLevelNext();
                return true;
            }
        }
        for (int localY = 0; localY < safeY; ++localY) {
            if (!this.canBreak(localPos.func_177982_a(0, localY, 0))) continue;
            this.destroyBlock(localPos.func_177982_a(0, localY, 0), this.frameWall, false, false);
        }
        ExternalPacketFXWispZap.zap((BlockPos)this.quarryPos, (BlockPos)localPos.func_177982_a(0, safeY, 0), (int)this.field_145850_b.field_73011_w.getDimension());
        this.quarryFuel.removeStored(1);
        ++this.tmpCounter;
        return false;
    }

    private IBlockState destroyBlock(BlockPos blockPos, IBlockState iBlockState, boolean consumeFuel, boolean doZap) {
        IBlockState returnBlock = null;
        if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() instanceof BlockFalling || this.field_145850_b.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof BlockFalling) {
            returnBlock = this.field_145850_b.func_180495_p(blockPos);
            if (this.canBreak(blockPos)) {
                this.field_145850_b.func_175656_a(blockPos, iBlockState);
            }
            for (int y = 1; y < 256 && this.field_145850_b.func_180495_p(blockPos.func_177982_a(0, y, 0)).func_177230_c() instanceof BlockFalling; ++y) {
                this.field_145850_b.func_175656_a(blockPos.func_177982_a(0, y, 0), Blocks.field_150350_a.func_176223_P());
            }
        } else if (this.field_145850_b.func_180495_p(blockPos).func_185904_a().func_76224_d()) {
            this.destroyFluid(blockPos.func_177956_o(), Blocks.field_150350_a.func_176223_P());
            returnBlock = Blocks.field_150350_a.func_176223_P();
        } else if (this.canBreak(blockPos)) {
            returnBlock = this.field_145850_b.func_180495_p(blockPos);
            this.field_145850_b.func_175656_a(blockPos, iBlockState);
        } else {
            return returnBlock;
        }
        if (doZap) {
            ExternalPacketFXWispZap.zap((BlockPos)this.quarryPos, (BlockPos)blockPos, (int)this.field_145850_b.field_73011_w.getDimension());
        }
        if (consumeFuel) {
            this.quarryFuel.removeStored(1);
            this.sendChangesToNearby();
        }
        return returnBlock;
    }

    public ItemStack generateDrops(BlockPos localPos) {
        IBlockState state = this.field_145850_b.func_180495_p(localPos);
        if (state.func_177230_c() instanceof BlockSlab) {
            return (ItemStack)state.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, localPos, state, 1).get(0);
        }
        boolean silkable = false;
        try {
            silkable = state.func_177230_c().canSilkHarvest(this.field_145850_b, this.field_174879_c, state, null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (silkable && !(state.func_177230_c() instanceof DraconiumOre)) {
            return state.func_177230_c().func_185473_a(this.field_145850_b, this.field_174879_c, state);
        }
        return new ItemStack(state.func_177230_c());
    }

    private boolean insertItemToPouch(ItemStack stack) {
        ItemStack pouch = this.inv.func_70301_a(1);
        if (!pouch.func_77973_b().getRegistryName().equals((Object)new ResourceLocation("enderstorage:ender_pouch"))) {
            return false;
        }
        Frequency frequency = Frequency.readFromStack((ItemStack)pouch);
        EnderItemStorage iInventoryPouch = (EnderItemStorage)EnderStorageManager.instance((boolean)this.field_145850_b.field_72995_K).getStorage(frequency, "item");
        for (int i = 0; i < iInventoryPouch.func_70302_i_(); ++i) {
            if (stack.func_190916_E() <= 0) {
                return true;
            }
            ItemStack pouchStack = iInventoryPouch.func_70301_a(i);
            if (pouchStack.func_77973_b().getRegistryName().equals((Object)new ResourceLocation("minecraft:air"))) {
                iInventoryPouch.func_70299_a(i, stack);
                return true;
            }
            if (!pouchStack.func_77969_a(stack) || pouchStack.func_77976_d() == pouchStack.func_190916_E()) continue;
            if (pouchStack.func_77976_d() >= stack.func_190916_E() + pouchStack.func_190916_E()) {
                pouchStack.func_190917_f(stack.func_190916_E());
                iInventoryPouch.func_70299_a(i, pouchStack);
                return true;
            }
            int amountToAdd = pouchStack.func_77976_d() - pouchStack.func_190916_E();
            pouchStack.func_190917_f(amountToAdd);
            iInventoryPouch.func_70299_a(i, pouchStack);
            stack.func_190918_g(amountToAdd);
        }
        return false;
    }

    private void updateFuelStored() {
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)this.inv.func_70301_a(0));
        if (fluidHandler == null) {
            if (this.attachedTankStored != 0) {
                this.attachedTankStored = 0;
                this.sendChangesToNearby();
            }
            return;
        }
        FluidStack fluidStack = fluidHandler.drain(Int.MaxValue(), false);
        if (fluidStack == null || fluidStack.getFluid() != FluidRegistry.getFluid((String)"refined_biofuel")) {
            if (this.attachedTankStored != 0) {
                this.attachedTankStored = 0;
                this.sendChangesToNearby();
            }
        } else if (this.attachedTankStored != fluidStack.amount) {
            this.attachedTankStored = fluidStack.amount;
            this.sendChangesToNearby();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkFuel() {
        if (this.quarryFuel.getStored() >= 2) {
            this.running = true;
            return true;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)this.inv.func_70301_a(0));
        if (fluidHandler == null) {
            return false;
        }
        FluidStack fluidStack = fluidHandler.drain(1280, false);
        if (fluidStack == null) {
            return false;
        }
        if (fluidStack.getFluid() != FluidRegistry.getFluid((String)"refined_biofuel")) {
            if (!this.running) return false;
            this.attachedTankStored = 0;
            this.running = false;
            this.sendChangesToNearby();
            return false;
        }
        FluidStack tmpFluidStack = fluidHandler.drain(Int.MaxValue(), false);
        fluidHandler.drain(fluidStack.amount, true);
        if (tmpFluidStack != null) {
            this.attachedTankStored = tmpFluidStack.amount;
        }
        this.quarryFuel.addStored((int)Math.abs((double)fluidStack.amount / 5.0));
        this.running = true;
        this.sendChangesToNearby();
        return true;
    }

    private void setupClient() {
        if (this.quarryPos == null) {
            this.initQuarry();
        }
        if (this.boundingBox == null || this.boundingBox.field_72338_b != (double)this.quarryPos.func_177956_o()) {
            this.boundingBox = new AxisAlignedBB((double)this.getChunkCoord(this.chunk.field_76635_g), (double)this.quarryPos.func_177956_o(), (double)this.getChunkCoord(this.chunk.field_76647_h), (double)(this.getChunkCoord(this.chunk.field_76635_g) + 16), (double)this.quarryPos.func_177956_o(), (double)(this.getChunkCoord(this.chunk.field_76647_h) + 16));
        }
        if (this.vortex == null) {
            this.vortex = new QuarryVortex(this);
        }
        SimpleQuarry.proxy.addParticleVortex(this.vortex);
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        return i;
    }

    public int getGrowth(IBlockState state) {
        return this.getMetaFromState(state) & 3;
    }

    private boolean miningTime() {
        ItemStack itemStack;
        BlockPos localPos = null;
        IBlockState minedBlock = null;
        while (true) {
            if ((localPos = this.getCurPos(this.tmpCounter, this.quarryPos.func_177956_o(), 1)) == null) {
                this.sendChangesToNearby();
                this.initLevelNext();
                return true;
            }
            ++this.tmpCounter;
            if (!this.canBreak(localPos)) continue;
            itemStack = this.generateDrops(localPos);
            if (!this.field_145850_b.func_175623_d(localPos) && (minedBlock = this.destroyBlock(localPos, Blocks.field_150350_a.func_176223_P(), true, true)) != null) break;
        }
        this.storeItem(itemStack);
        return false;
    }

    private void storeItem(ItemStack stack) {
        if (!this.insertItemToPouch(stack)) {
            TileEntity storage = this.field_145850_b.func_175625_s(this.quarryPos.func_177984_a());
            ItemInjector.inject(stack, storage, EnumFacing.UP);
        }
        ++this.totalBlocksMined;
        if (this.totalBlocksMined % (long)this.blocksPerQuarrySludge == 0L) {
            this.storeItem(new ItemStack(TorgoItems.QUARRY_SLUDGE));
        }
    }

    public void tick() {
        if (this.initLevel > 7) {
            return;
        }
        if (this.maxStepsX * this.maxStepsY < this.steps) {
            this.initLevelNext();
            return;
        }
        if (!this.atTickRate(this.setupTickRate)) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.setupClient();
            return;
        }
        if (!this.checkFuel()) {
            return;
        }
        this.updateFuelStored();
        this.initQuarry();
        switch (this.initLevel) {
            case 0: {
                this.clearSpace();
                break;
            }
            case 1: {
                this.createPillars();
                break;
            }
            case 2: {
                this.createFrame(this.getSafeY(this.quarryPos.func_177956_o() + 3), this.frameWall);
                break;
            }
            case 3: {
                this.createFrame(this.getSafeY(this.quarryPos.func_177956_o() - 1), this.framePath);
                break;
            }
            case 4: {
                this.createCrossPath();
                break;
            }
            case 5: {
                this.miningTime();
                break;
            }
            case 6: {
                this.clearPathForMinderMove();
                break;
            }
            case 7: {
                this.moveMiner();
            }
        }
    }

    public void clearPathForMinderMove() {
        BlockPos localPos;
        if (this.tmpCounter / 16 >= 2) {
            ++this.steps;
            this.sendChangesToNearby();
            this.initLevelNext();
            return;
        }
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.quarryPos).func_177229_b((IProperty)BlockFuelQuarry.FACING);
        do {
            localPos = this.quarryPos.func_177967_a(facing, this.tmpCounter % 16 + 1).func_177981_b(this.tmpCounter / 16);
            ++this.tmpCounter;
        } while (this.tmpCounter / 16 < 2 && (this.field_145850_b.func_175623_d(localPos) || this.field_145850_b.func_180495_p(localPos).func_185904_a().func_76224_d() || this.destroyBlock(localPos, Blocks.field_150350_a.func_176223_P(), false, true) == null));
    }

    public void setSteps(int newSteps) {
        this.steps = newSteps;
        this.sendChangesToNearby();
    }

    public void moveMiner() {
        BlockPos newPos;
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.quarryPos).func_177229_b((IProperty)BlockFuelQuarry.FACING);
        if (this.steps % this.maxStepsX == 0) {
            if (this.steps / this.maxStepsX % 2 == 0) {
                newPos = this.quarryPos.func_177967_a(facing.func_176746_e().func_176746_e().func_176746_e(), 16);
                this.field_145854_h.rotateBlock(this.field_145850_b, this.field_174879_c, facing.func_176746_e());
                this.field_145854_h.rotateBlock(this.field_145850_b, this.field_174879_c, facing.func_176746_e());
            } else {
                newPos = this.quarryPos.func_177967_a(facing.func_176746_e(), 16);
                this.field_145854_h.rotateBlock(this.field_145850_b, this.field_174879_c, facing.func_176746_e());
                this.field_145854_h.rotateBlock(this.field_145850_b, this.field_174879_c, facing.func_176746_e());
            }
            this.field_145850_b.func_180501_a(newPos, Blocks.field_150350_a.func_176223_P(), 3);
        } else {
            newPos = this.quarryPos.func_177967_a(facing, 16);
        }
        if (!this.field_145850_b.func_175623_d(newPos) && !this.field_145850_b.func_180495_p(newPos).func_185904_a().func_76224_d() || this.inv.func_70301_a(0).func_190926_b() || this.inv.func_70301_a(1).func_190926_b()) {
            return;
        }
        ExternalPacketFXWispZap.zap((BlockPos)this.quarryPos, (BlockPos)newPos, (int)this.field_145850_b.field_73011_w.getDimension());
        this.field_145850_b.func_180501_a(newPos, this.field_145850_b.func_180495_p(this.quarryPos), 3);
        this.field_145850_b.func_180495_p(newPos).func_177230_c().func_180633_a(this.field_145850_b, newPos, this.field_145850_b.func_180495_p(newPos), (EntityLivingBase)this.fakePlayer, new ItemStack(Blocks.field_150350_a));
        TileFuelQuarry newQuarry = (TileFuelQuarry)this.field_145850_b.func_175625_s(newPos);
        newQuarry.setSteps(this.steps);
        newQuarry.inv.func_70299_a(0, this.inv.func_70301_a(0));
        this.inv.func_70299_a(0, new ItemStack(Blocks.field_150350_a));
        newQuarry.inv.func_70299_a(1, this.inv.func_70301_a(1));
        this.inv.func_70299_a(1, new ItemStack(Blocks.field_150350_a));
        ExternalPacketFXWispZap.zap((BlockPos)newPos, (BlockPos)this.quarryPos, (int)this.field_145850_b.field_73011_w.getDimension());
        this.field_145850_b.func_175655_b(this.quarryPos, false);
        this.initLevelNext();
    }

    public void setRotation(Rotation rotationIn) {
        this.func_189667_a(rotationIn);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.initLevel = nbt.func_74762_e("initLevel");
        this.tmpCounter = nbt.func_74762_e("tmpCounter");
        this.attachedTankStored = nbt.func_74762_e("attachedTankStored");
        this.quarryFuel.setstorage(nbt.func_74762_e("storage"), nbt.func_74762_e("storageCapacity"));
        this.inv.readFromNBT(nbt.func_74775_l("Items"));
        this.totalBlocksMined = nbt.func_74763_f("totalBlocksMined");
        this.steps = nbt.func_74762_e("steps");
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("initLevel", this.initLevel);
        nbt.func_74768_a("tmpCounter", this.tmpCounter);
        nbt.func_74768_a("storage", this.quarryFuel.capacity);
        nbt.func_74768_a("attachedTankStored", this.attachedTankStored);
        nbt.func_74768_a("storageCapacity", this.quarryFuel.capacityStored);
        nbt.func_74772_a("totalBlocksMined", this.totalBlocksMined);
        nbt.func_74782_a("Items", (NBTBase)this.inv.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("steps", this.steps);
    }

    public boolean hasGui() {
        return true;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFuelQuarry(player, this);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerFuelQuarry(player, this);
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        this.inv.drop(world, pos);
    }

    public String getOwner() {
        return null;
    }

    public Object getMod() {
        return SimpleQuarry.instance;
    }

    public World getLoaderWorld() {
        return this.field_145850_b;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.deactivate();
        }
    }

    public BlockPos getPosition() {
        return this.quarryPos;
    }

    public void deactivate() {
        this.loaded = true;
        this.active = false;
        this.chunkLoaded = false;
        ChunkLoaderManager.remChunkLoader((IChickenChunkLoader)this);
    }

    public void activate() {
        if (this.chunkLoaded) {
            return;
        }
        this.chunkLoaded = true;
        this.loaded = true;
        this.active = true;
        ChunkLoaderManager.addChunkLoader((IChickenChunkLoader)this);
    }

    public Set<ChunkPos> getChunks() {
        return ChunkLoaderShape.Square.getLoadedChunks(this.quarryPos.func_177958_n() >> 4, this.quarryPos.func_177952_p() >> 4, 1);
    }
}

